/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.meta;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.CombineArchive;
import de.unirostock.sems.cbarchive.CombineArchiveException;
import de.unirostock.sems.cbarchive.Utils;
import de.unirostock.sems.cbarchive.meta.DefaultMetaDataObject;
import de.unirostock.sems.cbarchive.meta.MetaDataHolder;
import de.unirostock.sems.cbarchive.meta.MetaDataObject;
import de.unirostock.sems.cbarchive.meta.OmexMetaDataObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class MetaDataFile
extends MetaDataHolder {
    public static void readFile(Path file, HashMap<String, ArchiveEntry> entries, CombineArchive archive, MetaDataHolder metaMetaHolder, List<Path> metaDataFiles, boolean continueOnError, List<String> errors) throws ParseException, JDOMException, IOException, CombineArchiveException {
        Document doc = null;
        try {
            doc = Utils.readXmlDocument(file);
        }
        catch (JDOMException e) {
            LOGGER.error((Exception)((Object)e), (Object[])new Object[]{"cannot read manifest of archive"});
            errors.add("cannot read manifest of archive. xml seems to be invalid.");
            if (!continueOnError) {
                throw e;
            }
            return;
        }
        catch (IOException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot read manifest of archive."});
            errors.add("cannot read manifest of archive. io error.");
            if (!continueOnError) {
                throw e;
            }
            return;
        }
        List<Element> nl = Utils.getElementsByTagName(doc.getRootElement(), "Description", Utils.rdfNS);
        for (int i = 0; i < nl.size(); ++i) {
            Element current = nl.get(i);
            String about = current.getAttributeValue("about", Utils.rdfNS);
            if (about == null) {
                LOGGER.error((Object[])new Object[]{"meta description " + i + " in " + file + " does not contain an `about` value. so we cannot assign it to an entity."});
                errors.add("meta description " + i + " in " + file + " does not contain an `about` value. so we cannot assign it to an entity.");
                if (continueOnError) continue;
                throw new CombineArchiveException("meta description " + i + " in " + file + " does not contain an `about` value. so we cannot assign it to an entity.");
            }
            if (about.equals(".") || about.equals("/")) {
                if (MetaDataFile.addMetaToEntry(archive, current, null)) continue;
                LOGGER.warn((Object[])new Object[]{"could not parse description for ", about});
                continue;
            }
            if (about.startsWith("./")) {
                about = about.substring(2);
            }
            while (about.startsWith("/")) {
                about = about.substring(1);
            }
            about = "/" + about;
            MetaDataHolder currentEntry = null;
            String fragmentIdentifier = null;
            about = Utils.pathFixer(Paths.get(about, new String[0]).normalize().toString());
            for (ArchiveEntry entry : entries.values()) {
                if (!about.startsWith(entry.getFilePath()) || about.length() != entry.getFilePath().length() && about.charAt(entry.getFilePath().length()) != '#') continue;
                currentEntry = entry;
                if (about.length() <= entry.getFilePath().length() || about.charAt(entry.getFilePath().length()) != '#') break;
                fragmentIdentifier = about.substring(entry.getFilePath().length() - 1);
                break;
            }
            if (currentEntry == null && metaDataFiles != null) {
                for (Path p : metaDataFiles) {
                    String path = p.toString();
                    if (!about.startsWith(path) || about.length() != path.length() && about.charAt(path.length()) != '#') continue;
                    currentEntry = metaMetaHolder;
                    if (about.length() <= path.length() || about.charAt(path.length()) != '#') break;
                    fragmentIdentifier = about.substring(path.length() - 1);
                    break;
                }
            }
            if (currentEntry == null) {
                LOGGER.error((Object[])new Object[]{"found no entry for description ", i, " in ", file, " (about=", about, ")."});
                errors.add("found no entry for description " + i + " in " + file + " (about=" + about + ").");
                if (continueOnError) continue;
                throw new CombineArchiveException("found no entry for description " + current + "(" + i + ") in " + file + " (about=" + about + ").");
            }
            if (MetaDataFile.addMetaToEntry(currentEntry, current, fragmentIdentifier)) continue;
            LOGGER.warn((Object[])new Object[]{"could not parse description for ", about});
        }
    }

    public static int addAllMetaToEntry(Path file, ArchiveEntry entry) throws JDOMException, IOException {
        int added = 0;
        Document doc = Utils.readXmlDocument(file);
        List<Element> nl = Utils.getElementsByTagName(doc.getRootElement(), "Description", Utils.rdfNS);
        for (int i = 0; i < nl.size(); ++i) {
            int p;
            Element current = nl.get(i);
            String fragmentIdentifier = null;
            String about = current.getAttributeValue("about", Utils.rdfNS);
            if (about != null && (p = about.indexOf("#")) >= 0 && about.length() > p + 1) {
                fragmentIdentifier = about.substring(p + 1);
            }
            if (fragmentIdentifier != null) {
                current.setAttribute("about", entry.getEntityPath() + "#" + fragmentIdentifier, Utils.rdfNS);
            } else {
                current.setAttribute("about", entry.getEntityPath(), Utils.rdfNS);
            }
            if (!MetaDataFile.addMetaToEntry(entry, current, fragmentIdentifier)) {
                LOGGER.warn((Object[])new Object[]{"could not parse description for ", about});
                continue;
            }
            ++added;
        }
        return added;
    }

    private static boolean addMetaToEntry(MetaDataHolder entity, Element subtree, String fragmentIdentifier) {
        if (entity == null) {
            return false;
        }
        MetaDataObject object = null;
        object = OmexMetaDataObject.tryToRead(subtree);
        if (object == null) {
            object = DefaultMetaDataObject.tryToRead(subtree);
        }
        if (object != null) {
            object.setAbout(entity, fragmentIdentifier);
            for (MetaDataObject obj : entity.getDescriptions()) {
                if (!object.equals(obj)) continue;
                return true;
            }
        } else {
            return false;
        }
        entity.addDescription(fragmentIdentifier, object);
        return true;
    }

    public static List<File> writeFiles(File baseDir, HashMap<String, ArchiveEntry> entries, CombineArchive archive, MetaDataHolder metaMetaHolder) throws IOException, TransformerException {
        ArrayList<File> outputs = new ArrayList<File>();
        File output = MetaDataFile.getMetaOutputFile(baseDir);
        Document xmlDoc = new Document();
        Element rdf = new Element("RDF", Utils.rdfNS);
        xmlDoc.addContent((Content)rdf);
        rdf.addNamespaceDeclaration(Utils.dcNS);
        rdf.addNamespaceDeclaration(Utils.vcNS);
        MetaDataFile.exportMetaData(archive, rdf);
        MetaDataFile.exportMetaData(metaMetaHolder, rdf);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(output));){
            bw.write(Utils.prettyPrintDocument(xmlDoc));
        }
        catch (IOException | TransformerException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot write omex descriptions to ", output});
            throw e;
        }
        outputs.add(output);
        for (ArchiveEntry e : entries.values()) {
            output = MetaDataFile.getMetaOutputFile(baseDir);
            xmlDoc = new Document();
            rdf = new Element("RDF", Utils.rdfNS);
            xmlDoc.addContent((Content)rdf);
            rdf.addNamespaceDeclaration(Utils.dcNS);
            rdf.addNamespaceDeclaration(Utils.vcNS);
            MetaDataFile.exportMetaData(e, rdf);
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(output));){
                bw.write(Utils.prettyPrintDocument(xmlDoc));
            }
            catch (IOException | TransformerException ex) {
                LOGGER.error((Exception)ex, (Object[])new Object[]{"cannot write omex descriptions to ", output});
                throw ex;
            }
            outputs.add(output);
        }
        return outputs;
    }

    public static List<File> writeFile(File baseDir, HashMap<String, ArchiveEntry> entries, CombineArchive archive, MetaDataHolder metaMetaHolder) throws IOException, TransformerException {
        File output = MetaDataFile.getMetaOutputFile(baseDir);
        Document xmlDoc = new Document();
        Element rdf = new Element("RDF", Utils.rdfNS);
        xmlDoc.addContent((Content)rdf);
        rdf.addNamespaceDeclaration(Utils.dcNS);
        rdf.addNamespaceDeclaration(Utils.vcNS);
        MetaDataFile.exportMetaData(archive, rdf);
        MetaDataFile.exportMetaData(metaMetaHolder, rdf);
        for (ArchiveEntry e : entries.values()) {
            MetaDataFile.exportMetaData(e, rdf);
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(output));){
            bw.write(Utils.prettyPrintDocument(xmlDoc));
        }
        catch (IOException | TransformerException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"cannot write omex descriptions to ", output});
            throw e;
        }
        ArrayList<File> outputs = new ArrayList<File>();
        outputs.add(output);
        return outputs;
    }

    private static File getMetaOutputFile(File baseDir) {
        File output = new File(baseDir.getAbsolutePath() + File.separator + "metadata.rdf");
        int it = 0;
        while (output.exists()) {
            output = new File(baseDir.getAbsolutePath() + File.separator + "metadata-" + ++it + ".rdf");
        }
        return output;
    }

    private static void exportMetaData(MetaDataHolder entity, Element rdf) {
        for (MetaDataObject meta : entity.getDescriptions()) {
            Element Description = new Element("Description", Utils.rdfNS);
            String about = meta.getAbout();
            if (!about.startsWith(".")) {
                about = "." + about;
            }
            Description.setAttribute("about", about, Utils.rdfNS);
            rdf.addContent((Content)Description);
            meta.injectDescription(Description);
        }
    }

    @Override
    public String getEntityPath() {
        return "/metadata.rdf";
    }
}

