/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.model;

import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.CombineArchive;
import de.unirostock.sems.cbarchive.CombineArchiveException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.jdom2.JDOMException;

public final class CombineArchiveModel {
    private File archiveFile;
    private File workingCopyFile;
    private CombineArchive archive;
    private boolean unsavedChanges;

    public CombineArchiveModel(File archiveFile) throws IOException, JDOMException, ParseException, CombineArchiveException {
        this.archiveFile = archiveFile;
        this.workingCopyFile = File.createTempFile(archiveFile.getName(), ".tmp");
        Files.copy(archiveFile.toPath(), this.workingCopyFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        this.workingCopyFile.deleteOnExit();
        this.archive = new CombineArchive(this.workingCopyFile, true);
    }

    public Collection<?> listEntries() {
        return this.archive.getEntries();
    }

    public boolean hasMainEntry() {
        return this.archive.getMainEntry() != null;
    }

    public String getMainEntry() {
        ArchiveEntry ae = this.archive.getMainEntry();
        if (ae != null) {
            return ae.getFilePath();
        }
        return null;
    }

    public void setMainEntry(String entry) {
        ArchiveEntry ae = this.archive.getEntry(entry);
        if (ae != null) {
            this.archive.setMainEntry(ae);
        }
    }

    public void addEntry(File entry) throws IOException {
        this.addEntry(entry, false);
    }

    public void addEntry(File entry, boolean makeMain) throws IOException {
        this.archive.addEntry(entry, "", "", makeMain);
    }

    public void addEntries(Collection<File> entries) throws IOException {
        for (File entry : entries) {
            this.addEntry(entry);
        }
    }

    public void deleteEntry(String entry) throws IOException {
        this.archive.removeEntry(entry);
    }

    public void deleteEntries(Collection<String> entries) throws IOException {
        for (String entry : entries) {
            this.deleteEntry(entry);
        }
    }

    public boolean hasUnsavedChanges() {
        return this.unsavedChanges;
    }

    public void save() throws IOException, TransformerException {
        this.archive.pack();
        Files.copy(this.workingCopyFile.toPath(), this.archiveFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        this.unsavedChanges = false;
    }

    public void saveAs(File newArchiveFile) throws IOException, TransformerException {
        this.archiveFile = newArchiveFile;
        this.save();
    }

    public void close() throws Exception {
        this.close(false);
    }

    public void close(boolean force) throws Exception {
        if (this.hasUnsavedChanges() && !force) {
            throw new Exception("There are unsaved changes.");
        }
        this.archive.close();
        this.workingCopyFile.delete();
        this.archive = null;
        this.workingCopyFile = null;
        this.archiveFile = null;
    }

    public Object getMetadata(String entry) {
        ArchiveEntry ae = this.archive.getEntry(entry);
        if (ae != null) {
            List list = ae.getDescriptions();
        }
        return null;
    }

    public void addMetadata(String entry, Object metadata) {
        ArchiveEntry ae = this.archive.getEntry(entry);
    }

    public void removeMetadata(Object entry, Object metadata) {
    }

    public void updateMetadata(Object entry, Object metadata) {
    }
}

