/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.view;

import de.unirostock.sems.cbarchive.gui.Tools;
import de.unirostock.sems.cbarchive.gui.controller.MainController;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private MainController controller;
    private JScrollPane jScroll_TreePane;
    private JSplitPane jSplit_MainPane;

    public MainWindow(MainController controller) {
        this.controller = controller;
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.setTitle("Combine Archive Manager");
        this.setIconImages(this.loadApplicationImages());
        JMenuBar menubar = this.initializeMenuBar();
        this.setJMenuBar(menubar);
        this.jScroll_TreePane = new JScrollPane();
        this.jScroll_TreePane.setMinimumSize(new Dimension(200, 100));
        this.jScroll_TreePane.setPreferredSize(new Dimension(250, 100));
        this.jSplit_MainPane = new JSplitPane();
        this.jSplit_MainPane.setLeftComponent(this.jScroll_TreePane);
        this.jSplit_MainPane.setRightComponent(new JPanel());
        Container contentPane = this.getContentPane();
        contentPane.add(this.jSplit_MainPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                MainWindow.this.controller.goodBye();
            }
        });
    }

    private JMenuBar initializeMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu jM_File = new JMenu("File");
        jM_File.setMnemonic(70);
        JMenuItem jMI_File_New = new JMenuItem("New");
        jMI_File_New.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        ImageIcon icon = Tools.loadImageIcon("/icons/Tango/16x16/actions/filenew.png");
        jMI_File_New.setIcon(icon);
        jMI_File_New.setActionCommand("New");
        jMI_File_New.addActionListener(this.controller);
        JMenuItem jMI_File_Open = new JMenuItem("Open...");
        jMI_File_Open.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        icon = Tools.loadImageIcon("/icons/Tango/16x16/actions/fileopen.png");
        jMI_File_Open.setIcon(icon);
        jMI_File_Open.setActionCommand("Open");
        jMI_File_Open.addActionListener(this.controller);
        JMenuItem jMI_File_Close = new JMenuItem("Close");
        jMI_File_Close.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        jMI_File_Close.setActionCommand("Close");
        jMI_File_Close.addActionListener(this.controller);
        JMenuItem jMI_File_Save = new JMenuItem("Save");
        jMI_File_Save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        icon = Tools.loadImageIcon("/icons/Tango/16x16/actions/filesave.png");
        jMI_File_Save.setIcon(icon);
        jMI_File_Save.setActionCommand("Save");
        jMI_File_Save.addActionListener(this.controller);
        JMenuItem jMI_File_SaveAs = new JMenuItem("Save as...");
        icon = Tools.loadImageIcon("/icons/Tango/16x16/actions/filesaveas.png");
        jMI_File_SaveAs.setIcon(icon);
        jMI_File_SaveAs.setActionCommand("SaveAs");
        jMI_File_SaveAs.addActionListener(this.controller);
        JMenuItem jMI_File_Exit = new JMenuItem("Exit");
        icon = Tools.loadImageIcon("/icons/Tango/16x16/actions/exit.png");
        jMI_File_Exit.setIcon(icon);
        jMI_File_Exit.setActionCommand("Exit");
        jMI_File_Exit.addActionListener(this.controller);
        jM_File.add(jMI_File_New);
        jM_File.add(jMI_File_Open);
        jM_File.add(jMI_File_Close);
        jM_File.addSeparator();
        jM_File.add(jMI_File_Save);
        jM_File.add(jMI_File_SaveAs);
        jM_File.addSeparator();
        jM_File.add(jMI_File_Exit);
        menubar.add(jM_File);
        JMenu jM_Archive = new JMenu("Archive");
        jM_Archive.setMnemonic(65);
        JMenuItem jMI_Archive_Extract = new JMenuItem("Extract...");
        jMI_Archive_Extract.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMI_Archive_Extract.setActionCommand("Extract");
        jMI_Archive_Extract.addActionListener(this.controller);
        JMenuItem jMI_Archive_Add = new JMenuItem("Add File...");
        icon = Tools.loadImageIcon("/icons/Tango/16x16/actions/add.png");
        jMI_Archive_Add.setIcon(icon);
        jMI_Archive_Add.setActionCommand("AddFile");
        jMI_Archive_Add.addActionListener(this.controller);
        jM_Archive.add(jMI_Archive_Extract);
        jM_Archive.addSeparator();
        jM_Archive.add(jMI_Archive_Add);
        menubar.add(jM_Archive);
        JMenu jM_Tools = new JMenu("Tools");
        jM_Tools.setMnemonic(84);
        JMenuItem jMI_Tools_Options = new JMenuItem("Options");
        icon = Tools.loadImageIcon("/icons/Tango/16x16/categories/package_settings.png");
        jMI_Tools_Options.setIcon(icon);
        jMI_Tools_Options.setActionCommand("Options");
        jMI_Tools_Options.addActionListener(this.controller);
        jM_Tools.add(jMI_Tools_Options);
        menubar.add(jM_Tools);
        JMenu jM_Help = new JMenu("Help");
        jM_Help.setMnemonic(72);
        JMenuItem jMI_Help_Help = new JMenuItem("Combine Archive Manager help");
        jMI_Help_Help.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        icon = Tools.loadImageIcon("/icons/Tango/16x16/apps/help-browser.png");
        jMI_Help_Help.setIcon(icon);
        jMI_Help_Help.setActionCommand("Help");
        jMI_Help_Help.addActionListener(this.controller);
        JMenuItem jMI_Help_Console = new JMenuItem("Show Error Console");
        jMI_Help_Console.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        jMI_Help_Console.setActionCommand("ErrConsole");
        jMI_Help_Console.addActionListener(this.controller);
        JMenuItem jMI_Help_Settings = new JMenuItem("Settings");
        jMI_Help_Settings.setActionCommand("Settings");
        jMI_Help_Settings.addActionListener(this.controller);
        JMenuItem jMI_Help_About = new JMenuItem("About Combine Archive Manager");
        jMI_Help_About.setActionCommand("About");
        jMI_Help_About.addActionListener(this.controller);
        jM_Help.add(jMI_Help_Help);
        jM_Help.add(jMI_Help_Console);
        jM_Help.add(jMI_Help_Settings);
        jM_Help.addSeparator();
        jM_Help.add(jMI_Help_About);
        menubar.add(jM_Help);
        return menubar;
    }

    private List<Image> loadApplicationImages() {
        String filename = "gnome-mime-application-x-archive.png";
        int[] iconsizes = new int[]{16, 22, 24, 32, 48, 64, 72, 96, 128};
        String basepath = "/icons/Tango/";
        String iconcategory = "mimetypes";
        ArrayList<Image> images = new ArrayList<Image>();
        for (int size : iconsizes) {
            ImageIcon icon = Tools.loadImageIcon(basepath + size + "x" + size + "/" + iconcategory + "/" + filename);
            images.add(icon.getImage());
        }
        return images;
    }

    public void setFileTree(JTree fileTree) {
        this.jScroll_TreePane.getViewport().add(fileTree);
    }

    public void setDetails(JComponent panel) {
        this.jSplit_MainPane.setRightComponent(panel);
    }
}

