/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.controller;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.gui.controller.MainController;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveContentNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveEntryNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveFolderNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveNode;
import de.unirostock.sems.cbarchive.gui.model.FileTreeModel;
import de.unirostock.sems.cbarchive.gui.view.FileDialog;
import de.unirostock.sems.cbarchive.gui.view.FileTreeView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class FileTreeController
implements TreeSelectionListener,
MouseListener {
    private final MainController parentController;
    private FileTreeView view;
    private FileTreeModel model;
    private FileDialog fileDialog;

    public FileTreeController(MainController parentController, FileDialog fileDialog) {
        this.parentController = parentController;
        this.view = new FileTreeView(parentController, this);
        this.parentController.addFileTreePane(this.view);
        this.model = new FileTreeModel();
        this.fileDialog = fileDialog;
    }

    public JTree getView() {
        return this.view;
    }

    public void update(File archiveFile, List<ArchiveEntry> entries) {
        if (archiveFile != null) {
            this.model.add(archiveFile, entries);
        }
        this.view.setTree(this.model.generateTreeModel());
    }

    public void resetModel() {
        this.model.reset();
    }

    public CombineArchiveContentNode getSelectedEntryNode() {
        DefaultMutableTreeNode treeNode;
        Object usrObj;
        TreePath[] selectedPathsInTree = this.view.getSelectionPaths();
        if (selectedPathsInTree != null && selectedPathsInTree.length == 1 && (usrObj = (treeNode = (DefaultMutableTreeNode)selectedPathsInTree[0].getLastPathComponent()).getUserObject()) instanceof CombineArchiveContentNode) {
            CombineArchiveContentNode can = (CombineArchiveContentNode)usrObj;
            return can;
        }
        return null;
    }

    public File getSelectedArchiveFile() {
        DefaultMutableTreeNode treeNode;
        Object usrObj;
        TreePath[] selectedPathsInTree = this.view.getSelectionPaths();
        File archiveFile = null;
        if (selectedPathsInTree != null && selectedPathsInTree.length == 1 && (usrObj = (treeNode = (DefaultMutableTreeNode)selectedPathsInTree[0].getLastPathComponent()).getUserObject()) instanceof CombineArchiveNode) {
            CombineArchiveNode can = (CombineArchiveNode)usrObj;
            archiveFile = can.getArchiveFile();
        }
        return archiveFile;
    }

    public void moveArchiveEntry(File archive, ArchiveEntry entry, String newPath) {
        this.parentController.moveArchiveEntry(archive, entry, newPath);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.getSource() instanceof JTree) {
            JTree tree = (JTree)e.getSource();
            TreePath[] selectedPathsInTree = tree.getSelectionPaths();
            HashSet<CombineArchiveEntryNode> aes = new HashSet<CombineArchiveEntryNode>();
            if (selectedPathsInTree != null) {
                for (TreePath treePath : selectedPathsInTree) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    this.collectArchiveEntries(treeNode, aes);
                }
            }
            this.parentController.updateDetailsView(aes);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void contextClose(TreePath[] selectedPathsInTree, JPopupMenu popup) {
        Object usrObj = ((DefaultMutableTreeNode)selectedPathsInTree[0].getLastPathComponent()).getUserObject();
        if (usrObj instanceof CombineArchiveNode) {
            CombineArchiveNode arch = (CombineArchiveNode)usrObj;
            JMenuItem menuClose = new JMenuItem("close");
            menuClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.debug((Object[])new Object[]{"close archive "});
                    FileTreeController.this.parentController.closeArchiveFile();
                }
            });
            popup.addSeparator();
            popup.add(menuClose);
        }
    }

    private void contextAddFile(TreePath[] selectedPathsInTree, JPopupMenu popup) {
        Object usrObj = ((DefaultMutableTreeNode)selectedPathsInTree[0].getLastPathComponent()).getUserObject();
        if (usrObj instanceof CombineArchiveNode) {
            JMenuItem menuAdd = new JMenuItem("add files");
            menuAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.debug((Object[])new Object[]{"add files"});
                    FileTreeController.this.parentController.addFiles("/");
                }
            });
            popup.add(menuAdd);
        }
        if (usrObj instanceof CombineArchiveFolderNode) {
            final CombineArchiveFolderNode folder = (CombineArchiveFolderNode)usrObj;
            JMenuItem menuAdd = new JMenuItem("add files");
            menuAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.debug((Object[])new Object[]{"add files"});
                    FileTreeController.this.parentController.addFiles(folder.getPath() + "/");
                }
            });
            popup.add(menuAdd);
        }
    }

    private void contextRename(TreePath[] selectedPathsInTree, JPopupMenu popup) {
        Object usrObj = ((DefaultMutableTreeNode)selectedPathsInTree[0].getLastPathComponent()).getUserObject();
        if (usrObj instanceof CombineArchiveContentNode) {
            final CombineArchiveContentNode entryNode = (CombineArchiveContentNode)usrObj;
            JMenuItem menuRename = new JMenuItem("rename");
            menuRename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.debug((Object[])new Object[]{"renameEntry "});
                    FileTreeController.this.parentController.renameEntry(entryNode);
                }
            });
            popup.add(menuRename);
        }
    }

    private void contextExtract(final TreePath[] selectedPathsInTree, JPopupMenu popup) {
        JMenuItem menuExtract = new JMenuItem("extract");
        menuExtract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File target;
                HashSet aes = new HashSet();
                if (selectedPathsInTree != null) {
                    for (TreePath treePath : selectedPathsInTree) {
                        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        FileTreeController.this.collectArchiveEntries(treeNode, aes);
                    }
                }
                if (aes.size() > 0 && (target = FileTreeController.this.fileDialog.showExtractDialog(aes.size())) != null && target.exists() && target.isDirectory()) {
                    ArrayList<String> errors = new ArrayList<String>();
                    for (CombineArchiveEntryNode aen : aes) {
                        ArchiveEntry ae = aen.getArchiveEntry();
                        File targetFile = target;
                        LOGGER.info((Object[])new Object[]{"extracting path: ", ae.getFilePath(), " --to-> ", targetFile});
                        try {
                            if (targetFile.getParentFile().isDirectory() || targetFile.getParentFile().mkdirs()) {
                                boolean write = true;
                                if (new File(targetFile.getAbsolutePath() + File.separatorChar + ae.getFilePath()).exists()) {
                                    write = FileTreeController.this.parentController.showConfirmation("Override File?", ae.getFilePath() + " already exists in " + targetFile + ", do you want to replace it?");
                                }
                                if (!write) continue;
                                ae.extractFile(targetFile);
                                continue;
                            }
                            throw new IOException("couldn't create directory " + targetFile.getParentFile());
                        }
                        catch (IOException e1) {
                            errors.add(ae.getFilePath() + " failed: " + e1.getMessage());
                            LOGGER.error((Exception)e1, (Object[])new Object[]{"couldn't extract file ", ae.getFilePath(), " --to-> ", targetFile});
                        }
                    }
                    if (errors.size() > 0) {
                        String err = "Following errors occured:\n\n";
                        for (String er : errors) {
                            err = err + er + "\n";
                        }
                        FileTreeController.this.parentController.showError("error extracting files", err);
                    }
                }
            }
        });
        popup.add(menuExtract);
    }

    private void collectArchiveEntries(DefaultMutableTreeNode treeNode, Set<CombineArchiveEntryNode> aes) {
        Object can;
        Object usrObj = treeNode.getUserObject();
        if (usrObj instanceof CombineArchiveNode) {
            can = (CombineArchiveNode)usrObj;
            aes.addAll(((CombineArchiveNode)can).getArchiveEntries());
        }
        if (usrObj instanceof CombineArchiveContentNode) {
            can = (CombineArchiveContentNode)usrObj;
            aes.addAll(((CombineArchiveContentNode)can).getArchivesNodes());
        }
    }

    private void contextDebug(final TreePath[] selectedPathsInTree, JPopupMenu popup) {
        JMenuItem menuExtract = new JMenuItem("debug");
        menuExtract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashSet aes = new HashSet();
                if (selectedPathsInTree != null) {
                    for (TreePath treePath : selectedPathsInTree) {
                        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        FileTreeController.this.collectArchiveEntries(treeNode, aes);
                        LOGGER.debug((Object[])new Object[]{"entries: " + aes.size()});
                    }
                }
            }
        });
        popup.add(menuExtract);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof JTree) {
            JTree tree = (JTree)e.getSource();
            int selRow = this.view.getRowForLocation(e.getX(), e.getY());
            if (selRow != -1) {
                TreePath[] selectedPathsInTree = tree.getSelectionPaths();
                if (e.getClickCount() == 1 && e.getButton() == 3 && selectedPathsInTree != null && selectedPathsInTree.length > 0) {
                    JPopupMenu popup = new JPopupMenu();
                    LOGGER.debug((Object[])new Object[]{"selectedPathsInTree length: ", selectedPathsInTree.length});
                    if (selectedPathsInTree.length == 1) {
                        this.contextRename(selectedPathsInTree, popup);
                    }
                    this.contextAddFile(selectedPathsInTree, popup);
                    this.contextExtract(selectedPathsInTree, popup);
                    this.contextClose(selectedPathsInTree, popup);
                    popup.show(tree, e.getX(), e.getY());
                } else if (e.getClickCount() == 2) {
                    // empty if block
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

