/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.controller;

import de.binfalse.bflog.LOGGER;
import de.binfalse.bflog.LogCallback;
import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.CombineArchive;
import de.unirostock.sems.cbarchive.CombineArchiveException;
import de.unirostock.sems.cbarchive.gui.controller.DetailsPanelController;
import de.unirostock.sems.cbarchive.gui.controller.FileTreeController;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveContentNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveEntryNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveFolderNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveNode;
import de.unirostock.sems.cbarchive.gui.model.MainModel;
import de.unirostock.sems.cbarchive.gui.view.FileDialog;
import de.unirostock.sems.cbarchive.gui.view.LogWindow;
import de.unirostock.sems.cbarchive.gui.view.MainWindow;
import de.unirostock.sems.cbarchive.gui.view.SettingsWindow;
import de.unirostock.sems.cbarchive.meta.MetaDataObject;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.xml.transform.TransformerException;
import org.jdom2.JDOMException;

public final class MainController
implements ActionListener {
    private static Preferences prefs = Preferences.userNodeForPackage(MainController.class);
    private MainWindow view = new MainWindow(this);
    private MainModel model = new MainModel();
    private FileTreeController fileTreeController;
    private DetailsPanelController detailsPanelControler;
    private FileDialog fileDialog = new FileDialog(this.view);
    private LogWindow logWindow;

    public MainController() {
        this.fileTreeController = new FileTreeController(this, this.fileDialog);
        this.view.setFileTree(this.fileTreeController.getView());
        this.detailsPanelControler = new DetailsPanelController(this, this.fileDialog);
        this.logWindow = new LogWindow((Window)this.view);
        LOGGER.addCallback((LogCallback)this.logWindow);
        LOGGER.setLogToStdErr((boolean)false);
        LOGGER.setLogToStdOut((boolean)false);
        LOGGER.setLogStackTrace((boolean)MainController.getLogStackTrace());
        LOGGER.setMinLevel((int)MainController.getLogLevel());
    }

    public void display() {
        this.view.setSize(800, 600);
        this.view.setVisible(true);
    }

    public void addFileTreePane(JTree fileTree) {
        this.view.setFileTree(fileTree);
    }

    public List<MetaDataObject> getMetaData(ArchiveEntry entry) {
        return entry.getDescriptions();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actCmdString;
        switch (actCmdString = e.getActionCommand()) {
            case "New": {
                this.createArchiveFile();
                break;
            }
            case "Open": {
                this.openArchiveFile();
                break;
            }
            case "Close": {
                this.closeArchiveFile();
                break;
            }
            case "Exit": {
                this.goodBye();
                break;
            }
            case "Extract": {
                LOGGER.debug((Object[])new Object[]{"clicked Menu -> Archive -> Extract"});
                break;
            }
            case "AddFile": {
                String targetBase = "";
                CombineArchiveContentNode node = this.fileTreeController.getSelectedEntryNode();
                if (node instanceof CombineArchiveFolderNode) {
                    targetBase = ((CombineArchiveFolderNode)node).getPath() + "/";
                }
                this.addFiles(targetBase);
                break;
            }
            case "Options": {
                LOGGER.debug((Object[])new Object[]{"clicked Menu -> Tools -> Options"});
                break;
            }
            case "Help": {
                LOGGER.debug((Object[])new Object[]{"clicked Menu -> Help -> Help"});
                break;
            }
            case "ErrConsole": {
                LOGGER.debug((Object[])new Object[]{"clicked Menu -> Help -> Console"});
                this.logWindow.setVisible(true);
                break;
            }
            case "Settings": {
                SettingsWindow settingsWindow = new SettingsWindow((Window)this.view);
                settingsWindow.setVisible(true);
                break;
            }
            case "About": {
                this.updateDetailsView(new ArrayList<CombineArchiveEntryNode>());
                break;
            }
            default: {
                LOGGER.debug((Object[])new Object[]{"Some other action was selected which is not yet implemented."});
                LOGGER.debug((Object[])new Object[]{"Action -> ", e.getActionCommand(), " \t\t", "by -> ", e.getSource()});
            }
        }
    }

    private void createArchiveFile() {
        File archiveFile = this.fileDialog.showCreateCombineArchiveDialog();
        if (archiveFile != null) {
            try {
                this.model.createArchive(archiveFile);
                LOGGER.debug((Object[])new Object[]{"archive created in model"});
                this.fileTreeController.update(archiveFile, this.model.listEntries(archiveFile));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.view, "Combine archive could not be created.", "Error", 0);
                LOGGER.error((Exception)e, (Object[])new Object[]{"Error while creating combine archive at ", archiveFile});
            }
        }
    }

    public void addFiles(String targetBase) {
        File[] files;
        for (File f : files = this.fileDialog.showAddFilesDialog()) {
            LOGGER.debug((Object[])new Object[]{"Selected files -> " + f});
        }
        File archive = this.fileTreeController.getSelectedArchiveFile();
        if (archive == null) {
            CombineArchiveContentNode entry = this.fileTreeController.getSelectedEntryNode();
            if (entry != null) {
                archive = entry.getArchiveNode().getArchiveFile();
            }
            LOGGER.debug((Object[])new Object[]{"did not select an archive, but an entry? ", archive});
        }
        if (archive == null) {
            JOptionPane.showMessageDialog(this.view, "Please select an entry in the tree.", "Please select an entry in the file tree.", 1);
        } else {
            for (File parentFile : files) {
                List<File> subfiles = this.listFiles(parentFile);
                for (File f : subfiles) {
                    String targetName = null;
                    targetName = parentFile.isDirectory() ? f.getAbsolutePath().replace(parentFile.getAbsolutePath(), "") : parentFile.getName();
                    try {
                        this.model.addFile(f, targetBase + targetName, archive);
                    }
                    catch (IOException | TransformerException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.fileTreeController.update(archive, this.model.listEntries(archive));
    }

    private List<File> listFiles(File parent) {
        ArrayList<File> files = new ArrayList<File>();
        if (parent.isDirectory()) {
            for (File file : parent.listFiles()) {
                files.addAll(this.listFiles(file));
            }
        } else {
            files.add(parent);
        }
        return files;
    }

    private void openArchiveFile() {
        LOGGER.debug((Object[])new Object[]{"clicked Menu -> File -> Open"});
        File omexFile = this.fileDialog.showOpenCombineArchiveDialog();
        if (omexFile != null) {
            try {
                this.model.openArchive(omexFile);
                this.fileTreeController.update(omexFile, this.model.listEntries(omexFile));
            }
            catch (CombineArchiveException | IOException | ParseException | JDOMException e) {
                JOptionPane.showMessageDialog(this.view, "Combine archive could not be opened.", "Error", 0);
                LOGGER.error((Exception)e, (Object[])new Object[]{"Combine archive could not be opened"});
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.view, "Combine archive could not be opened.", "Error", 0);
                LOGGER.error((Exception)e, (Object[])new Object[]{"Combine archive could not be opened"});
            }
        }
    }

    public void reloadTree() {
        this.fileTreeController.resetModel();
        Collection<File> openedArchiveFiles = this.model.getArchives();
        if (openedArchiveFiles.isEmpty()) {
            this.fileTreeController.update(null, null);
        } else {
            for (File openedArchiveFile : this.model.getArchives()) {
                LOGGER.debug((Object[])new Object[]{"Updating for ", openedArchiveFile.getName()});
                this.fileTreeController.update(openedArchiveFile, this.model.listEntries(openedArchiveFile));
            }
        }
    }

    public void closeArchiveFile() {
        File archiveFile = this.fileTreeController.getSelectedArchiveFile();
        if (archiveFile == null) {
            JOptionPane.showMessageDialog(this.view, "Please only select an archive file.", "Please select archive file.", 1);
        } else {
            int retVal = JOptionPane.showConfirmDialog(this.view, "Do you really want to close:\n  " + archiveFile.getName() + "?");
            if (retVal == 0) {
                LOGGER.debug((Object[])new Object[]{"Closing combine archive ", archiveFile.getName(), "..."});
                try {
                    this.model.closeArchive(archiveFile);
                }
                catch (IOException | TransformerException e) {
                    LOGGER.error((Exception)e, (Object[])new Object[]{"wasn't able to close the archive in "});
                    JOptionPane.showMessageDialog(this.view, "Something went wrong while closing the combine archive. See the log file.", "Error", 0);
                }
                this.reloadTree();
            }
        }
    }

    public void extractArchive(File destination, File archive) {
        LOGGER.info((Object[])new Object[]{"extracting archive: ", archive, " --to-> ", destination});
        try {
            this.model.extractArchive(destination, archive);
        }
        catch (IOException e1) {
            this.showError("Error extracting archive", "Failed to extract archive: " + e1.getMessage());
            LOGGER.error((Exception)e1, (Object[])new Object[]{"couldn't extract archive ", archive, " --to-> ", destination});
        }
    }

    public void moveArchiveEntry(File archive, ArchiveEntry entry, String newPath) {
        try {
            this.model.moveArchiveEntry(archive, entry, newPath);
        }
        catch (IOException | TransformerException e) {
            e.printStackTrace();
        }
    }

    public void updateDetailsView(Collection<CombineArchiveEntryNode> selectedArchiveEntries) {
        for (CombineArchiveEntryNode archiveEntry : selectedArchiveEntries) {
            LOGGER.debug((Object[])new Object[]{archiveEntry, " -> ", archiveEntry.getArchiveEntry().getFileName()});
        }
        this.view.setDetails(this.detailsPanelControler.renderDetails(selectedArchiveEntries));
    }

    public static String getDefaultPath() {
        return prefs.get("defaultPath", System.getProperty("user.home"));
    }

    public static void setDefaultPath(String path) {
        prefs.put("defaultPath", path);
    }

    public static boolean getPopUpLog() {
        return prefs.get("popUpLog", "jau").equals("jau");
    }

    public static void setPopUpLog(boolean confirm) {
        prefs.put("popUpLog", confirm ? "jau" : "noe");
    }

    public static boolean getConfirmExit() {
        return prefs.get("confirmExit", "jau").equals("jau");
    }

    public static void setComfirmExit(boolean confirm) {
        prefs.put("confirmExit", confirm ? "jau" : "noe");
    }

    public static void setLogStackTrace(boolean logStack) {
        prefs.put("logStackTrace", logStack ? "jau" : "noe");
    }

    public static boolean getLogStackTrace() {
        return prefs.get("logStackTrace", "jau").equals("jau");
    }

    public static void setLogLevel(String level) {
        prefs.put("logLevel", level);
    }

    public static int getLogLevel() {
        String level = prefs.get("logLevel", "WARN");
        if (level.equals("DEBUG")) {
            return 1;
        }
        if (level.equals("INFO")) {
            return 2;
        }
        if (level.equals("ERROR")) {
            return 8;
        }
        return 4;
    }

    public void showError(String title, String err) {
        JOptionPane.showMessageDialog(this.view, err, title, 0);
    }

    public boolean showConfirmation(String title, String msg) {
        return 0 == JOptionPane.showConfirmDialog(this.view, msg, title, 0);
    }

    public String askTheUser(String title, String question, String defaultAnswer) {
        return (String)JOptionPane.showInputDialog(this.view, question, title, 3, null, null, defaultAnswer);
    }

    public void goodBye() {
        Object[] options;
        int n;
        if (!MainController.getConfirmExit()) {
            System.exit(0);
        }
        if ((n = JOptionPane.showOptionDialog(this.view, "you have XXX unsaved stuff. really exit?", "close?", 1, 3, null, options = new Object[]{"Yes, stop asking!", "Yes", "No"}, options[2])) == 0) {
            MainController.setComfirmExit(false);
        }
        if (n < 2) {
            System.exit(0);
        }
    }

    public void reformatEntry(ArchiveEntry entry) {
        String uri = this.askTheUser("new format", "what's the format of this file?", entry.getFormat().toString());
        try {
            URI newUri = new URI(uri);
            entry.setFormat(newUri);
        }
        catch (URISyntaxException e) {
            this.showError("unsupported format!", "the new format is not a valid URI!");
            LOGGER.error((Exception)e, (Object[])new Object[]{"the new format is not a valid URI."});
        }
    }

    public void renameEntry(CombineArchiveContentNode entry) {
        String newName = this.askTheUser("new name", "how do you want to name the file?", entry.getName());
        if (newName != null) {
            if (newName.length() < 1 || newName.contains("/") || newName.contains("\\")) {
                this.showError("unsupported file name!", "file name has to contain at least one char and must not contain / or \\!");
            } else {
                try {
                    entry.rename(newName);
                    this.reloadTree();
                }
                catch (IOException e) {
                    LOGGER.error((Exception)e, (Object[])new Object[]{"couldn't rename entry ", entry.getName()});
                    this.showError("error renaming entry", "couldn't rename entry " + entry.getName());
                }
            }
        }
    }

    public void move(CombineArchiveContentNode caen, CombineArchiveFolderNode destObj) throws IOException {
        String destPath = destObj.getPath();
        if (caen instanceof CombineArchiveEntryNode) {
            ArchiveEntry entry = ((CombineArchiveEntryNode)caen).getArchiveEntry();
            CombineArchive ca = entry.getArchive();
            String target = destPath + "/" + entry.getFileName();
            LOGGER.debug((Object[])new Object[]{"moving ", entry.getEntityPath(), " to ", target});
            ca.moveEntry(entry.getEntityPath(), target);
            ((CombineArchiveEntryNode)caen).setArchiveEntry(ca.getEntry(target));
        }
        if (caen instanceof CombineArchiveFolderNode) {
            CombineArchiveFolderNode base = (CombineArchiveFolderNode)caen;
            CombineArchiveFolderNode baseParent = base.getParentNode();
            String basePath = baseParent == null ? "" : baseParent.getPath();
            Collection<CombineArchiveEntryNode> entries = base.getArchivesNodes();
            for (CombineArchiveEntryNode entry : entries) {
                ArchiveEntry ae = entry.getArchiveEntry();
                CombineArchive ca = ae.getArchive();
                String target = ae.getEntityPath().replaceFirst(basePath, destPath);
                LOGGER.debug((Object[])new Object[]{"moving ", ae.getEntityPath(), " to ", target});
                ca.moveEntry(ae.getEntityPath(), target);
                entry.setArchiveEntry(ca.getEntry(target));
            }
        }
    }

    public void move(CombineArchiveContentNode caen, CombineArchiveNode destObj) throws IOException {
        if (caen instanceof CombineArchiveEntryNode) {
            ArchiveEntry entry = ((CombineArchiveEntryNode)caen).getArchiveEntry();
            CombineArchive ca = entry.getArchive();
            String target = "/" + entry.getFileName();
            LOGGER.debug((Object[])new Object[]{"moving ", entry.getEntityPath(), " to ", target});
            ca.moveEntry(entry.getEntityPath(), target);
            ((CombineArchiveEntryNode)caen).setArchiveEntry(ca.getEntry(target));
        }
        if (caen instanceof CombineArchiveFolderNode) {
            CombineArchiveFolderNode base = (CombineArchiveFolderNode)caen;
            CombineArchiveFolderNode baseParent = base.getParentNode();
            if (baseParent == null) {
                return;
            }
            String basePath = baseParent.getPath();
            Collection<CombineArchiveEntryNode> entries = base.getArchivesNodes();
            for (CombineArchiveEntryNode entry : entries) {
                ArchiveEntry ae = entry.getArchiveEntry();
                CombineArchive ca = ae.getArchive();
                String target = ae.getEntityPath().replaceFirst(basePath, "");
                LOGGER.debug((Object[])new Object[]{"moving ", ae.getEntityPath(), " to ", target});
                ca.moveEntry(ae.getEntityPath(), target);
                entry.setArchiveEntry(ca.getEntry(target));
            }
        }
    }
}

