/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.model;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveContentNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveEntryNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveNode;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;

public class CombineArchiveFolderNode
extends CombineArchiveContentNode {
    private Map<String, CombineArchiveContentNode> children = new LinkedHashMap<String, CombineArchiveContentNode>();
    private CombineArchiveFolderNode parentFolder;

    public CombineArchiveFolderNode(String name, CombineArchiveNode archiveNode, CombineArchiveFolderNode parentFolder) {
        super(name, archiveNode);
        this.parentFolder = parentFolder;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addEntry(String path, ArchiveEntry entry) {
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        int pos = path.indexOf("/");
        if (pos < 0) {
            this.children.put(path, new CombineArchiveEntryNode(path, entry, this.archiveNode));
            return;
        }
        String folder = path.substring(0, pos);
        CombineArchiveContentNode folderNode = this.children.get(folder);
        if (folderNode == null) {
            folderNode = new CombineArchiveFolderNode(folder, this.archiveNode, this);
            this.children.put(folder, folderNode);
        }
        if (folderNode instanceof CombineArchiveFolderNode) {
            ((CombineArchiveFolderNode)folderNode).addEntry(path.substring(pos), entry);
            return;
        }
        LOGGER.error((Object[])new Object[]{"cannot add an archive entry file below an archive entry."});
        throw new UnsupportedOperationException("cannot add an archive entry file below an archive entry.");
    }

    public int getNumChildren() {
        return this.children.size();
    }

    @Override
    public Collection<CombineArchiveEntryNode> getArchivesNodes() {
        HashSet<CombineArchiveEntryNode> nodes = new HashSet<CombineArchiveEntryNode>();
        for (Map.Entry<String, CombineArchiveContentNode> node : this.children.entrySet()) {
            nodes.addAll(node.getValue().getArchivesNodes());
        }
        return nodes;
    }

    @Override
    public void generateTreeModel(DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(this);
        parent.add(treeNode);
        for (Map.Entry<String, CombineArchiveContentNode> node : this.children.entrySet()) {
            node.getValue().generateTreeModel(treeNode);
        }
    }

    public CombineArchiveFolderNode getParentNode() {
        return this.parentFolder;
    }

    public String getPath() {
        if (this.parentFolder == null) {
            return "/" + this.name;
        }
        return this.parentFolder.getPath() + "/" + this.name;
    }

    private void updatePaths() throws IOException {
        for (Map.Entry<String, CombineArchiveContentNode> node : this.children.entrySet()) {
            CombineArchiveContentNode child = node.getValue();
            if (child instanceof CombineArchiveFolderNode) {
                ((CombineArchiveFolderNode)child).updatePaths();
            }
            if (!(child instanceof CombineArchiveEntryNode)) continue;
            ((CombineArchiveEntryNode)child).move(this.getPath());
        }
    }

    @Override
    public void rename(String newName) throws IOException {
        this.name = newName;
        this.updatePaths();
    }
}

