/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.model;

import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveNode;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class FileTreeModel {
    private Map<File, CombineArchiveNode> archives = new LinkedHashMap<File, CombineArchiveNode>();

    public void add(File archiveFile, List<ArchiveEntry> entries) {
        CombineArchiveNode can = this.archives.get(archiveFile);
        if (can == null) {
            can = new CombineArchiveNode(archiveFile);
            this.archives.put(archiveFile, can);
        }
        for (ArchiveEntry ae : entries) {
            can.addEntry(ae);
        }
    }

    public void reset() {
        this.archives.clear();
    }

    public TreeNode generateTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (CombineArchiveNode archive : this.archives.values()) {
            DefaultMutableTreeNode atn = new DefaultMutableTreeNode(archive);
            archive.generateTreeModel(atn);
            root.add(atn);
        }
        return root;
    }
}

