/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.model;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.CombineArchive;
import de.unirostock.sems.cbarchive.CombineArchiveException;
import de.unirostock.sems.cbarchive.meta.MetaDataObject;
import de.unirostock.sems.cbext.Formatizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.jdom2.JDOMException;

public final class MainModel {
    private Map<File, CombineArchive> archives = new LinkedHashMap<File, CombineArchive>();

    public void createArchive(File archiveFile) throws Exception {
        LOGGER.debug((Object[])new Object[]{"Creating archive file ", archiveFile});
        File caf = this.getCanonicalFile(archiveFile);
        LOGGER.debug((Object[])new Object[]{"Canonical file for ", archiveFile.getAbsolutePath(), " is ", caf.getAbsolutePath()});
        if (!this.archives.containsKey(caf)) {
            LOGGER.debug((Object[])new Object[]{"Creating combine archive ..."});
            CombineArchive ca = new CombineArchive(caf);
            LOGGER.debug((Object[])new Object[]{"Combine archive created ", ca});
            this.archives.put(caf, ca);
        }
    }

    public void openArchive(File archiveFile) throws IOException, JDOMException, ParseException, CombineArchiveException {
        File caf = this.getCanonicalFile(archiveFile);
        if (!this.archives.containsKey(caf)) {
            try {
                CombineArchive ca = new CombineArchive(caf);
                this.archives.put(caf, ca);
            }
            catch (Exception e) {
                LOGGER.error((Exception)e, (Object[])new Object[]{"couldn't open archive"});
            }
        }
    }

    public Collection<File> getArchives() {
        return this.archives.keySet();
    }

    public void closeArchive(File archiveFile) throws IOException, TransformerException {
        File caf = this.getCanonicalFile(archiveFile);
        CombineArchive ca = this.archives.remove(caf);
        if (ca != null) {
            ca.pack();
            ca.close();
        }
    }

    public void extractArchive(File destination, File archiveFile) throws IOException {
        File caf = this.getCanonicalFile(archiveFile);
        CombineArchive ca = this.archives.get(caf);
        if (ca != null) {
            ca.extractTo(destination);
        }
    }

    public void extractArchiveEntries(File destination, File archiveFile, Collection<ArchiveEntry> archiveEntries) throws IOException {
        File caf = this.getCanonicalFile(archiveFile);
        CombineArchive ca = this.archives.get(caf);
        if (ca != null) {
            Collection caEntries = ca.getEntries();
            if (destination.isFile() && archiveEntries.size() >= 1) {
                destination = destination.getParentFile();
            }
            for (ArchiveEntry ae : archiveEntries) {
                if (!caEntries.contains(ae)) continue;
                ae.extractFile(destination);
            }
        }
    }

    public void addFile(File file, String targetName, File archiveFile) throws IOException, TransformerException {
        File caf = this.getCanonicalFile(archiveFile);
        CombineArchive ca = this.archives.get(caf);
        if (ca != null) {
            URI format = Formatizer.guessFormat((File)file);
            ca.addEntry(file, targetName, format);
            ca.pack();
        }
    }

    public void moveArchiveEntry(File archive, ArchiveEntry entry, String newPath) throws IOException, TransformerException {
        CombineArchive ca = this.archives.get(archive);
        if (ca != null && ca.getEntries().contains(entry)) {
            ca.moveEntry(entry.getEntityPath(), newPath);
            ca.pack();
        }
    }

    public void moveArchiveEntriesToArchive(File fromArchive, List<ArchiveEntry> entries, File toArchive, String newPath) throws IOException, TransformerException {
        CombineArchive caFrom = this.archives.get(fromArchive);
        CombineArchive caTo = this.archives.get(toArchive);
        if (caFrom != null && caTo != null) {
            Collection archiveEntries = caFrom.getEntries();
            for (ArchiveEntry entry : entries) {
                if (!archiveEntries.contains(entry)) continue;
                List metadata = entry.getDescriptions();
                URI format = entry.getFormat();
                File extractedFile = entry.extractFile(File.createTempFile("omex_", null, null));
                caFrom.removeEntry(entry);
                caFrom.pack();
                ArchiveEntry ae = caTo.addEntry(extractedFile, newPath, format);
                for (MetaDataObject metaDataObject : metadata) {
                    ae.addDescription(metaDataObject);
                }
                caTo.pack();
            }
        }
    }

    public List<ArchiveEntry> listEntries(File archiveFile) {
        ArrayList<ArchiveEntry> entries = new ArrayList<ArchiveEntry>();
        if (this.archives.containsKey(archiveFile)) {
            CombineArchive ca = this.archives.get(archiveFile);
            entries.addAll(ca.getEntries());
        }
        return entries;
    }

    private File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return file;
        }
    }
}

