/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.view;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.gui.controller.MainController;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class FileDialog {
    private final JFileChooser jfcDialog = new JFileChooser();
    private final FileNameExtensionFilter fnefSpecifiedCombineArchives = new FileNameExtensionFilter("Combine archive", "omex", "sedx", "sbex", "cmex", "neux", "phex", "sbox");
    private final FileNameExtensionFilter fnefOmex = new FileNameExtensionFilter("COMBINE archive (*.omex)", "omex");
    private final FileNameExtensionFilter fnefSedx = new FileNameExtensionFilter("SED-ML archive (*.sedx)", "sedx");
    private final FileNameExtensionFilter fnefSbex = new FileNameExtensionFilter("SBML archive (*.sbex)", "sbex");
    private final FileNameExtensionFilter fnefCmex = new FileNameExtensionFilter("CellML archive (*.cmex)", "cmex");
    private final FileNameExtensionFilter fnefNeux = new FileNameExtensionFilter("NeuroML archive (*.neux)", "neux");
    private final FileNameExtensionFilter fnefPhex = new FileNameExtensionFilter("PharmML archive (*.phex)", "phex");
    private final FileNameExtensionFilter fnefSbox = new FileNameExtensionFilter("SBOL archive (*.sbox)", "sbox");
    private final Component parent;

    public FileDialog(Component parent) {
        this.parent = parent;
    }

    public File showCreateCombineArchiveDialog() {
        this.jfcDialog.resetChoosableFileFilters();
        this.jfcDialog.setFileSelectionMode(0);
        this.jfcDialog.setMultiSelectionEnabled(false);
        this.jfcDialog.setFileFilter(this.fnefOmex);
        this.jfcDialog.setFileFilter(this.fnefSedx);
        this.jfcDialog.setFileFilter(this.fnefSbex);
        this.jfcDialog.setFileFilter(this.fnefCmex);
        this.jfcDialog.setFileFilter(this.fnefNeux);
        this.jfcDialog.setFileFilter(this.fnefPhex);
        this.jfcDialog.setFileFilter(this.fnefSbox);
        this.jfcDialog.setFileFilter(this.fnefOmex);
        this.jfcDialog.setAcceptAllFileFilterUsed(false);
        this.jfcDialog.setCurrentDirectory(new File(MainController.getDefaultPath()));
        int retcode = this.jfcDialog.showDialog(this.parent, "Create");
        File omexFile = null;
        switch (retcode) {
            case 0: {
                omexFile = this.jfcDialog.getSelectedFile();
                MainController.setDefaultPath(omexFile.getParentFile().getAbsolutePath());
                break;
            }
            case 1: {
                LOGGER.debug((Object[])new Object[]{"Create Archive: Operation canceled."});
                break;
            }
            case -1: {
                LOGGER.debug((Object[])new Object[]{"Create Archive: Some error occurred."});
                break;
            }
            default: {
                LOGGER.debug((Object[])new Object[]{"Create Archive: Something else happened."});
            }
        }
        FileNameExtensionFilter selectedFnef = (FileNameExtensionFilter)this.jfcDialog.getFileFilter();
        String[] fileExtensions = selectedFnef.getExtensions();
        if (fileExtensions.length > 0) {
            String useFileExtension = fileExtensions[0];
            if (omexFile != null) {
                String filename = omexFile.getName();
                int idx = filename.lastIndexOf(46);
                if (idx != -1) {
                    String fileextension = filename.substring(idx + 1);
                    if ("useFileExtension".compareToIgnoreCase(fileextension) != 0) {
                        filename = filename + "." + useFileExtension;
                        omexFile = new File(omexFile.getParent() + File.separator + filename);
                    }
                } else {
                    filename = filename + "." + useFileExtension;
                    omexFile = new File(omexFile.getParent() + File.separator + filename);
                }
            }
        }
        LOGGER.debug((Object[])new Object[]{"Creating archive ", omexFile != null ? omexFile.getAbsolutePath() : "{null}"});
        return omexFile;
    }

    public File showOpenCombineArchiveDialog() {
        this.jfcDialog.resetChoosableFileFilters();
        this.jfcDialog.setFileSelectionMode(0);
        this.jfcDialog.setMultiSelectionEnabled(false);
        this.jfcDialog.addChoosableFileFilter(this.fnefSpecifiedCombineArchives);
        this.jfcDialog.setFileFilter(this.fnefSpecifiedCombineArchives);
        this.jfcDialog.setAcceptAllFileFilterUsed(true);
        this.jfcDialog.setCurrentDirectory(new File(MainController.getDefaultPath()));
        int retcode = this.jfcDialog.showOpenDialog(this.parent);
        File omexFile = null;
        switch (retcode) {
            case 0: {
                omexFile = this.jfcDialog.getSelectedFile();
                MainController.setDefaultPath(omexFile.getParentFile().getAbsolutePath());
                break;
            }
            case 1: {
                LOGGER.debug((Object[])new Object[]{"Open Archive: Operation canceled."});
                break;
            }
            case -1: {
                LOGGER.debug((Object[])new Object[]{"Open Archive: Some error occurred."});
                break;
            }
            default: {
                LOGGER.debug((Object[])new Object[]{"Open Archive: Something else happened."});
            }
        }
        LOGGER.debug((Object[])new Object[]{"Loading archive ", omexFile != null ? "'" + omexFile.getAbsolutePath() + "'" : "{null}"});
        return omexFile;
    }

    public File showExtractDialog(int nFiles) {
        this.jfcDialog.resetChoosableFileFilters();
        this.jfcDialog.setFileSelectionMode(1);
        this.jfcDialog.setMultiSelectionEnabled(false);
        this.jfcDialog.setCurrentDirectory(new File(MainController.getDefaultPath()));
        int retcode = this.jfcDialog.showDialog(this.parent, "Extract " + nFiles + " File" + (nFiles == 1 ? "" : "s") + "...");
        switch (retcode) {
            case 0: {
                File f = this.jfcDialog.getSelectedFile();
                MainController.setDefaultPath(f.getAbsolutePath());
                return f;
            }
            case 1: {
                LOGGER.debug((Object[])new Object[]{"Extracting: Operation canceled."});
                break;
            }
            case -1: {
                LOGGER.debug((Object[])new Object[]{"Extracting: Some error occurred."});
                break;
            }
            default: {
                LOGGER.debug((Object[])new Object[]{"Extracting: Something else happened."});
            }
        }
        return null;
    }

    public File[] showAddFilesDialog() {
        this.jfcDialog.resetChoosableFileFilters();
        this.jfcDialog.setFileSelectionMode(2);
        this.jfcDialog.setMultiSelectionEnabled(true);
        this.jfcDialog.setAcceptAllFileFilterUsed(true);
        this.jfcDialog.setCurrentDirectory(new File(MainController.getDefaultPath()));
        int retcode = this.jfcDialog.showDialog(this.parent, "Add...");
        File[] files = null;
        switch (retcode) {
            case 0: {
                files = this.jfcDialog.getSelectedFiles();
                if (files == null || files.length < 1) break;
                MainController.setDefaultPath(files[0].getParentFile().getAbsolutePath());
                break;
            }
            case 1: {
                LOGGER.debug((Object[])new Object[]{"Operation canceled."});
                break;
            }
            case -1: {
                LOGGER.debug((Object[])new Object[]{"Some error occurred."});
                break;
            }
            default: {
                LOGGER.debug((Object[])new Object[]{"Something else happened."});
            }
        }
        if (files != null) {
            for (File file : files) {
                LOGGER.debug((Object[])new Object[]{"Loading file ", file != null ? "'" + file.getAbsolutePath() + "'" : "{null}"});
            }
        } else {
            LOGGER.debug((Object[])new Object[]{"Loading file {null}..."});
        }
        return files;
    }
}

