/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.view;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.gui.Tools;
import de.unirostock.sems.cbarchive.gui.controller.FileTreeController;
import de.unirostock.sems.cbarchive.gui.controller.MainController;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveContentNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveEntryNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveFolderNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveNode;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileTreeView
extends JTree {
    private final MainController mainController;
    private static final long serialVersionUID = 1L;
    private FileTreeController controller;

    public FileTreeView(MainController mainController, FileTreeController controller) {
        this.controller = controller;
        this.mainController = mainController;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel tm = new DefaultTreeModel(root);
        this.setModel(tm);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new FileTreeCellRenderer());
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setTransferHandler(new TreeTransferHandler());
        this.addTreeSelectionListener(controller);
        this.addMouseListener(controller);
    }

    public void setTree(TreeNode root) {
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.setModel(treeModel);
        this.revalidate();
        this.repaint();
    }

    private class TreeTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        DataFlavor nodesFlavor;
        DataFlavor[] flavors = new DataFlavor[1];
        DefaultMutableTreeNode[] nodesToRemove;

        public TreeTransferHandler() {
            try {
                String mimeType = "application/x-java-jvm-local-objectref;class=\"" + DefaultMutableTreeNode[].class.getName() + "\"";
                this.flavors[0] = this.nodesFlavor = new DataFlavor(mimeType);
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug((Exception)e, (Object[])new Object[]{"trasferring failed -- ClassNotFound"});
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            support.setShowDropLocation(true);
            if (!support.isDataFlavorSupported(this.nodesFlavor)) {
                return false;
            }
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            JTree tree = (JTree)support.getComponent();
            int dropRow = tree.getRowForPath(dl.getPath());
            int[] selRows = tree.getSelectionRows();
            for (int i = 0; i < selRows.length; ++i) {
                if (selRows[i] != dropRow) continue;
                return false;
            }
            TreePath dest = dl.getPath();
            DefaultMutableTreeNode target = (DefaultMutableTreeNode)dest.getLastPathComponent();
            return target.getUserObject() instanceof CombineArchiveFolderNode || target.getUserObject() instanceof CombineArchiveNode;
        }

        private boolean haveCompleteNode(JTree tree) {
            int[] selRows = tree.getSelectionRows();
            TreePath path = tree.getPathForRow(selRows[0]);
            DefaultMutableTreeNode first = (DefaultMutableTreeNode)path.getLastPathComponent();
            int childCount = first.getChildCount();
            if (childCount > 0 && selRows.length == 1) {
                return false;
            }
            for (int i = 1; i < selRows.length; ++i) {
                path = tree.getPathForRow(selRows[i]);
                DefaultMutableTreeNode next = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!first.isNodeChild(next) || childCount <= selRows.length - 1) continue;
                return false;
            }
            return true;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTree tree = (JTree)c;
            TreePath[] paths = tree.getSelectionPaths();
            if (paths != null) {
                DefaultMutableTreeNode next;
                ArrayList<DefaultMutableTreeNode> copies = new ArrayList<DefaultMutableTreeNode>();
                ArrayList<DefaultMutableTreeNode> toRemove = new ArrayList<DefaultMutableTreeNode>();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                DefaultMutableTreeNode copy = this.copy(node);
                copies.add(copy);
                toRemove.add(node);
                for (int i = 1; i < paths.length && (next = (DefaultMutableTreeNode)paths[i].getLastPathComponent()).getLevel() >= node.getLevel(); ++i) {
                    if (next.getLevel() > node.getLevel()) {
                        copy.add(this.copy(next));
                        continue;
                    }
                    copies.add(this.copy(next));
                    toRemove.add(next);
                }
                DefaultMutableTreeNode[] nodes = copies.toArray(new DefaultMutableTreeNode[copies.size()]);
                this.nodesToRemove = toRemove.toArray(new DefaultMutableTreeNode[toRemove.size()]);
                return new NodesTransferable(nodes);
            }
            return null;
        }

        private DefaultMutableTreeNode copy(TreeNode node) {
            DefaultMutableTreeNode copy = this.cloneSubtree((DefaultMutableTreeNode)node);
            return copy;
        }

        private DefaultMutableTreeNode cloneSubtree(DefaultMutableTreeNode tree) {
            DefaultMutableTreeNode copy = (DefaultMutableTreeNode)tree.clone();
            for (int i = 0; i < tree.getChildCount(); ++i) {
                copy.add(this.cloneSubtree((DefaultMutableTreeNode)tree.getChildAt(i)));
            }
            return copy;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if ((action & 2) == 2) {
                JTree tree = (JTree)source;
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                for (int i = 0; i < this.nodesToRemove.length; ++i) {
                    model.removeNodeFromParent(this.nodesToRemove[i]);
                }
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            TreePath insertPath;
            if (!this.canImport(support)) {
                return false;
            }
            DefaultMutableTreeNode toInsert = null;
            try {
                Transferable t = support.getTransferable();
                DefaultMutableTreeNode[] nodes = (DefaultMutableTreeNode[])t.getTransferData(this.nodesFlavor);
                if (nodes.length != 1) {
                    return false;
                }
                toInsert = nodes[0];
            }
            catch (UnsupportedFlavorException ufe) {
                LOGGER.debug((Exception)ufe, (Object[])new Object[]{"importing data failed"});
            }
            catch (IOException ioe) {
                LOGGER.debug((Exception)ioe, (Object[])new Object[]{"importing data failed"});
            }
            if (toInsert == null) {
                return false;
            }
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            int childIndex = dl.getChildIndex();
            TreePath dest = dl.getPath();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dest.getLastPathComponent();
            TreePath parentPath = new TreePath(parent.getPath());
            if (parentPath.isDescendant(insertPath = new TreePath(toInsert.getPath()))) {
                return false;
            }
            JTree tree = (JTree)support.getComponent();
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            int index = childIndex;
            if (childIndex == -1) {
                index = parent.getChildCount();
            }
            CombineArchiveContentNode caen = (CombineArchiveContentNode)toInsert.getUserObject();
            Object destObj = parent.getUserObject();
            if (destObj instanceof CombineArchiveEntryNode) {
                return false;
            }
            if (destObj instanceof CombineArchiveFolderNode) {
                try {
                    FileTreeView.this.mainController.move(caen, (CombineArchiveFolderNode)destObj);
                }
                catch (IOException e) {
                    LOGGER.error((Exception)e, (Object[])new Object[]{"couldn't move entries"});
                    FileTreeView.this.mainController.showError("error moving entries", "couldn't move entries. see log viewer for details.");
                    return false;
                }
            }
            if (destObj instanceof CombineArchiveNode) {
                try {
                    FileTreeView.this.mainController.move(caen, (CombineArchiveNode)destObj);
                }
                catch (IOException e) {
                    LOGGER.error((Exception)e, (Object[])new Object[]{"couldn't move entries"});
                    FileTreeView.this.mainController.showError("error moving entries", "couldn't move entries. see log viewer for details.");
                    return false;
                }
            }
            model.insertNodeInto(toInsert, parent, index++);
            return true;
        }

        public String toString() {
            return this.getClass().getName();
        }

        public class NodesTransferable
        implements Transferable {
            DefaultMutableTreeNode[] nodes;

            public NodesTransferable(DefaultMutableTreeNode[] nodes) {
                this.nodes = nodes;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                return this.nodes;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return TreeTransferHandler.this.flavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return TreeTransferHandler.this.nodesFlavor.equals(flavor);
            }
        }
    }

    class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        FileTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
                Object userObject = treeNode.getUserObject();
                if (userObject instanceof CombineArchiveNode) {
                    this.setIcon(Tools.loadImageIcon("/icons/Tango/16x16/mimetypes/gnome-mime-application-x-archive.png"));
                }
                if (userObject instanceof CombineArchiveContentNode) {
                    if (userObject instanceof CombineArchiveEntryNode) {
                        this.setIcon(Tools.scaleIcon(Tools.loadImageIcon(((CombineArchiveEntryNode)userObject).getArchiveEntry().getFormat()), 22, 22));
                    }
                    if (userObject instanceof CombineArchiveFolderNode) {
                        this.setIcon(Tools.loadImageIcon("/icons/Tango/16x16/places/folder.png"));
                    }
                }
            }
            return this;
        }
    }
}

