/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.view;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.gui.controller.MainController;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class SettingsWindow
extends JDialog {
    public static final String LOG_DEBUG = "DEBUG";
    public static final String LOG_INFO = "INFO";
    public static final String LOG_WARNING = "WARNING";
    public static final String LOG_ERROR = "ERROR";
    private static final long serialVersionUID = 1L;

    public SettingsWindow(Window owner) {
        super(owner, "Settings", Dialog.ModalityType.TOOLKIT_MODAL);
        this.setUndecorated(false);
        JLabel labelLogLevel = new JLabel("Log Level:");
        final JComboBox<String> chooseLogLevel = new JComboBox<String>();
        chooseLogLevel.setModel(new DefaultComboBoxModel<String>(new String[]{LOG_DEBUG, LOG_INFO, LOG_WARNING, LOG_ERROR}));
        chooseLogLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newLvl = chooseLogLevel.getSelectedItem().toString();
                MainController.setLogLevel(newLvl);
                LOGGER.setMinLevel((int)MainController.getLogLevel());
                LOGGER.debug((Object[])new Object[]{"set new log lvl: " + newLvl});
            }
        });
        switch (MainController.getLogLevel()) {
            case 1: {
                chooseLogLevel.setSelectedIndex(0);
                break;
            }
            case 2: {
                chooseLogLevel.setSelectedIndex(1);
                break;
            }
            case 8: {
                chooseLogLevel.setSelectedIndex(3);
                break;
            }
            default: {
                chooseLogLevel.setSelectedIndex(2);
            }
        }
        JLabel labelStackTrace = new JLabel("Log Stack Traces:");
        final JComboBox<String> chooseStackTrace = new JComboBox<String>();
        chooseStackTrace.setModel(new DefaultComboBoxModel<String>(new String[]{"yes", "no"}));
        chooseStackTrace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean st = chooseStackTrace.getSelectedItem().toString().equals("yes");
                MainController.setLogStackTrace(st);
                LOGGER.setLogStackTrace((boolean)st);
                LOGGER.debug((Object[])new Object[]{"set loging stack traces: " + st});
            }
        });
        if (!MainController.getLogStackTrace()) {
            chooseStackTrace.setSelectedIndex(1);
        }
        JLabel labelShowLog = new JLabel("Show Log Window in case of fire:");
        final JComboBox<String> chooseShowLog = new JComboBox<String>();
        chooseShowLog.setModel(new DefaultComboBoxModel<String>(new String[]{"yes", "no"}));
        chooseShowLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean st = chooseShowLog.getSelectedItem().toString().equals("yes");
                MainController.setPopUpLog(st);
            }
        });
        if (!MainController.getPopUpLog()) {
            chooseShowLog.setSelectedIndex(1);
        }
        JLabel labelConfirmExit = new JLabel("Confirm Exit:");
        final JComboBox<String> chooseConfirmExit = new JComboBox<String>();
        chooseConfirmExit.setModel(new DefaultComboBoxModel<String>(new String[]{"yes", "no"}));
        chooseConfirmExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean st = chooseConfirmExit.getSelectedItem().toString().equals("yes");
                MainController.setComfirmExit(st);
            }
        });
        if (!MainController.getConfirmExit()) {
            chooseConfirmExit.setSelectedIndex(1);
        }
        JButton jButton1 = new JButton("close");
        jButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SettingsWindow.this.dispose();
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(labelStackTrace).addComponent(labelLogLevel).addComponent(labelShowLog).addComponent(labelConfirmExit)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(chooseConfirmExit, -2, -1, -2).addComponent(chooseStackTrace, -2, -1, -2).addComponent(chooseShowLog, -2, -1, -2).addComponent(chooseLogLevel, -2, -1, -2)).addContainerGap(180, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(jButton1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(labelLogLevel).addComponent(chooseLogLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(labelStackTrace).addComponent(chooseStackTrace, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(labelShowLog).addComponent(chooseShowLog, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(labelConfirmExit).addComponent(chooseConfirmExit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 167, Short.MAX_VALUE).addComponent(jButton1).addContainerGap()));
        this.setMinimumSize(new Dimension(800, 400));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int windowX = Math.max(0, screenSize.width / 2 - 400);
        int windowY = Math.max(0, screenSize.height / 2 - 200);
        this.setLocation(windowX, windowY);
    }
}

