/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbext.Iconizer;
import java.awt.Image;
import java.net.URI;
import java.net.URL;
import javax.swing.ImageIcon;

public class Tools {
    public static String humanReadable(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        return String.format("%.1f %sB", (double)bytes / Math.pow(1024.0, exp), "KMGTPE".charAt(exp - 1) + "i");
    }

    public static ImageIcon loadImageIcon(URI format) {
        URL imgURL = Iconizer.formatToIconUrl((URI)format);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        LOGGER.error((Object[])new Object[]{"Couldn't load image for file format: ", format});
        return null;
    }

    public static ImageIcon loadImageIcon(String path) {
        URL imgURL = Tools.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        LOGGER.error((Object[])new Object[]{"Couldn't load image file: ", path});
        return null;
    }

    public static ImageIcon scaleIcon(ImageIcon icon, int w, int h) {
        Image image = icon.getImage();
        Image newimg = image.getScaledInstance(w, h, 4);
        return new ImageIcon(newimg);
    }
}

