/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.controller;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.Utils;
import de.unirostock.sems.cbarchive.gui.Tools;
import de.unirostock.sems.cbarchive.gui.controller.MainController;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveEntryNode;
import de.unirostock.sems.cbarchive.gui.view.FileDialog;
import de.unirostock.sems.cbarchive.meta.MetaDataObject;
import de.unirostock.sems.cbarchive.meta.OmexMetaDataObject;
import de.unirostock.sems.cbarchive.meta.omex.OmexDescription;
import de.unirostock.sems.cbarchive.meta.omex.VCard;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.jdom2.Document;

public class DetailsPanelController {
    private final MainController parentController;
    private JPanel aboutPanel;
    private FileDialog fileDialog;

    public DetailsPanelController(MainController parentController, FileDialog fileDialog) {
        this.parentController = parentController;
        this.fileDialog = fileDialog;
        this.aboutPanel = new JPanel();
        JLabel jLabel1 = new JLabel("flo was here");
        GroupLayout layout = new GroupLayout(this.aboutPanel);
        this.aboutPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addContainerGap(337, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addContainerGap(273, Short.MAX_VALUE)));
    }

    public JComponent renderDetails(Collection<CombineArchiveEntryNode> entries) {
        if (entries.size() == 1) {
            return this.renderDetails(entries.iterator().next());
        }
        if (entries.size() > 1) {
            return this.listEntries(entries);
        }
        return this.aboutPanel;
    }

    private JComponent listEntries(Collection<CombineArchiveEntryNode> entries) {
        JPanel panel = new JPanel();
        ArrayList<JLabel> labelsLeft = new ArrayList<JLabel>();
        ArrayList<JLabel> labelsRight = new ArrayList<JLabel>();
        for (CombineArchiveEntryNode entryNode : entries) {
            ArchiveEntry entry = entryNode.getArchiveEntry();
            String size = "";
            try {
                size = " " + Tools.humanReadable(Files.size(entry.getPath()));
            }
            catch (IOException e) {
                LOGGER.error((Object[])new Object[]{"wasn't able to compute the size of file " + entry.getPath()});
            }
            labelsRight.add(new JLabel(entry.getEntityPath() + " (" + entry.getFormat() + size + ")"));
            labelsLeft.add(new JLabel(Tools.loadImageIcon(entry.getFormat())));
        }
        Collections.sort(labelsRight, new Comparator<JLabel>(){

            @Override
            public int compare(JLabel o1, JLabel o2) {
                return o1.getText().toLowerCase().compareTo(o2.getText().toLowerCase());
            }
        });
        GroupLayout layout = new GroupLayout(panel);
        GroupLayout.ParallelGroup pgLeft = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.ParallelGroup pgRight = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        for (JLabel l : labelsRight) {
            pgRight = pgRight.addComponent(l);
        }
        for (JLabel l : labelsLeft) {
            pgLeft = pgLeft.addComponent(l);
        }
        GroupLayout.SequentialGroup sg = layout.createSequentialGroup().addContainerGap();
        for (int i = 0; i < labelsLeft.size(); ++i) {
            sg = sg.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)labelsLeft.get(i)).addComponent((Component)labelsRight.get(i))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(pgLeft).addGroup(pgRight).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sg.addContainerGap()));
        return panel;
    }

    public JComponent renderDetails(final CombineArchiveEntryNode entryNode) {
        final ArchiveEntry entry = entryNode.getArchiveEntry();
        List<MetaDataObject> meta = this.parentController.getMetaData(entry);
        JTabbedPane pane = new JTabbedPane();
        for (MetaDataObject m : meta) {
            String txt;
            Document doc = new Document();
            doc.setRootElement(m.getXmlDescription().clone());
            try {
                txt = Utils.prettyPrintDocument((Document)doc);
            }
            catch (Exception e) {
                txt = "couldn't extract xml";
            }
            LOGGER.debug((Object[])new Object[]{txt});
            JPanel details = null;
            if (m instanceof OmexMetaDataObject) {
                OmexMetaDataObject omex = (OmexMetaDataObject)m;
                details = this.renderOmexMetaData(omex);
            } else {
                details = this.renderDefaultMetaData(m);
            }
            pane.addTab("tmp", new JScrollPane(details));
        }
        String size = "";
        try {
            size = " " + Tools.humanReadable(Files.size(entry.getPath()));
        }
        catch (IOException e) {
            LOGGER.error((Object[])new Object[]{"wasn't able to compute the size of file " + entry.getPath()});
        }
        JPanel panel = new JPanel();
        JLabel infoIcon = new JLabel(Tools.loadImageIcon(entry.getFormat()));
        JLabel info = new JLabel(entry.getEntityPath() + " (" + entry.getFormat() + size + ")");
        JButton renamer = new JButton("rename");
        renamer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailsPanelController.this.parentController.renameEntry(entryNode);
            }
        });
        JButton reformater = new JButton("change format");
        reformater.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailsPanelController.this.parentController.reformatEntry(entry);
            }
        });
        JButton extracter = new JButton("extract");
        extracter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = DetailsPanelController.this.fileDialog.showExtractDialog(1);
                try {
                    entry.extractFile(f);
                    LOGGER.debug((Object[])new Object[]{"extracted ", entry.getPath(), " to ", f});
                }
                catch (IOException ex) {
                    LOGGER.error((Exception)ex, (Object[])new Object[]{"unable to extract entry ", entry.getPath(), " to ", f});
                }
            }
        });
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(infoIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(info).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(renamer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(reformater).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(extracter).addContainerGap()).addComponent(pane, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(info).addComponent(infoIcon).addComponent(renamer).addComponent(extracter).addComponent(reformater)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(pane, -1, 490, Short.MAX_VALUE)));
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(panel);
        return scroller;
    }

    private JPanel renderDefaultMetaData(MetaDataObject m) {
        String txt;
        JTextArea text = new JTextArea();
        Document doc = new Document();
        doc.setRootElement(m.getXmlDescription().clone());
        try {
            txt = Utils.prettyPrintDocument((Document)doc);
        }
        catch (Exception e) {
            txt = "couldn't extract xml";
        }
        text.setText(txt);
        LOGGER.debug((Object[])new Object[]{m.toString()});
        JScrollPane scroller = new JScrollPane(text);
        JButton save = new JButton("save");
        JPanel panel = new JPanel();
        GroupLayout panelLayout = new GroupLayout(panel);
        panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(save)).addComponent(scroller, -1, 100, Short.MAX_VALUE)).addContainerGap()));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addComponent(scroller, -1, 100, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(save).addContainerGap()));
        return panel;
    }

    private JPanel renderOmexMetaData(OmexMetaDataObject omex) {
        OmexDescription descr = omex.getOmexDescription();
        JPanel creators = new JPanel();
        creators.setLayout(new FlowLayout(0));
        List people = descr.getCreators();
        for (VCard p : people) {
            JPanel creator = new JPanel();
            creator.setBorder(BorderFactory.createTitledBorder("Creator"));
            JLabel jLabel5 = new JLabel("family name");
            JLabel jLabel6 = new JLabel(p.getFamilyName());
            JLabel jLabel7 = new JLabel("given name");
            JLabel jLabel8 = new JLabel(p.getGivenName());
            JLabel jLabel9 = new JLabel("mail");
            JLabel jLabel10 = new JLabel(p.getEmail());
            JLabel jLabel11 = new JLabel("organization");
            JLabel jLabel12 = new JLabel(p.getOrganization());
            GroupLayout creatorLayout = new GroupLayout(creator);
            creator.setLayout(creatorLayout);
            creatorLayout.setHorizontalGroup(creatorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(creatorLayout.createSequentialGroup().addContainerGap().addGroup(creatorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel7).addComponent(jLabel5).addComponent(jLabel9).addComponent(jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(creatorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel12).addComponent(jLabel10).addComponent(jLabel6).addComponent(jLabel8)).addContainerGap(-1, Short.MAX_VALUE)));
            creatorLayout.setVerticalGroup(creatorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(creatorLayout.createSequentialGroup().addContainerGap().addGroup(creatorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(creatorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel7).addComponent(jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(creatorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel9).addComponent(jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addGroup(creatorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel11).addComponent(jLabel12)).addContainerGap()));
            creators.add(creator);
        }
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel("created:");
        JLabel jLabel2 = new JLabel("modified:");
        JLabel jLabel3 = new JLabel(descr.getCreated().toString());
        StringBuilder mod = new StringBuilder();
        for (Date m : descr.getModified()) {
            mod.append(m.toString()).append(" ");
        }
        JLabel jLabel4 = new JLabel(mod.toString());
        JButton jButton1 = new JButton("edit");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(jLabel2, -1, 87, Short.MAX_VALUE).addComponent(jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel3).addComponent(jLabel4)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(jButton1).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jButton1).addContainerGap(423, Short.MAX_VALUE)));
        JPanel panel = new JPanel();
        GroupLayout panelLayout = new GroupLayout(panel);
        panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelLayout.createSequentialGroup().addContainerGap().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addComponent(creators, -1, 778, Short.MAX_VALUE)).addContainerGap()));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addComponent(creators, -2, -1, -2).addGap(18, 18, 18).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        return panel;
    }
}

