/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.model;

import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.CombineArchive;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveContentNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveNode;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;

public class CombineArchiveEntryNode
extends CombineArchiveContentNode {
    private ArchiveEntry entry;

    public CombineArchiveEntryNode(String name, ArchiveEntry entry, CombineArchiveNode archiveNode) {
        super(name, archiveNode);
        this.entry = entry;
    }

    public void setArchiveEntry(ArchiveEntry entry) {
        this.entry = entry;
    }

    public ArchiveEntry getArchiveEntry() {
        return this.entry;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public void generateTreeModel(DefaultMutableTreeNode parent) {
        parent.add(new DefaultMutableTreeNode(this));
    }

    @Override
    public Collection<CombineArchiveEntryNode> getArchivesNodes() {
        HashSet<CombineArchiveEntryNode> nodes = new HashSet<CombineArchiveEntryNode>();
        nodes.add(this);
        return nodes;
    }

    public void move(String newPath) throws IOException {
        CombineArchive ca = this.entry.getArchive();
        ca.moveEntry(this.entry.getEntityPath(), newPath + "/" + this.entry.getFileName());
    }

    @Override
    public void rename(String newName) throws IOException {
        CombineArchive ca = this.entry.getArchive();
        ca.moveEntry(this.entry.getEntityPath(), this.entry.getEntityPath().substring(0, this.entry.getEntityPath().length() - this.entry.getFileName().length()) + newName);
    }
}

