/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbarchive.gui.model;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbarchive.ArchiveEntry;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveContentNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveEntryNode;
import de.unirostock.sems.cbarchive.gui.model.CombineArchiveFolderNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;

public class CombineArchiveNode {
    private File archiveFile;
    private Map<String, CombineArchiveContentNode> childrenNodes;

    public CombineArchiveNode(File archiveFile) {
        this.archiveFile = archiveFile;
        this.childrenNodes = new LinkedHashMap<String, CombineArchiveContentNode>();
    }

    public File getArchiveFile() {
        return this.archiveFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addEntry(ArchiveEntry ae) throws UnsupportedOperationException {
        if (ae == null) return;
        String path = ae.getEntityPath();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        int pos = path.indexOf("/");
        if (pos < 0) {
            this.childrenNodes.put(path, new CombineArchiveEntryNode(path, ae, this));
            return;
        }
        String folder = path.substring(0, pos);
        CombineArchiveContentNode folderNode = this.childrenNodes.get(folder);
        if (folderNode == null) {
            folderNode = new CombineArchiveFolderNode(folder, this, null);
            this.childrenNodes.put(folder, folderNode);
        }
        if (folderNode instanceof CombineArchiveFolderNode) {
            ((CombineArchiveFolderNode)folderNode).addEntry(path.substring(pos), ae);
            return;
        }
        LOGGER.error((Object[])new Object[]{"cannot add an archive entry file below an archive entry."});
        throw new UnsupportedOperationException("cannot add an archive entry file below an archive entry.");
    }

    public void generateTreeModel(DefaultMutableTreeNode parent) {
        ArrayList<CombineArchiveContentNode> caes = new ArrayList<CombineArchiveContentNode>(this.childrenNodes.values());
        Collections.sort(caes);
        for (CombineArchiveContentNode cae : caes) {
            cae.generateTreeModel(parent);
        }
    }

    public Collection<CombineArchiveEntryNode> getArchiveEntries() {
        HashSet<CombineArchiveEntryNode> entries = new HashSet<CombineArchiveEntryNode>();
        for (CombineArchiveContentNode caen : this.childrenNodes.values()) {
            entries.addAll(caen.getArchivesNodes());
        }
        return entries;
    }

    public String toString() {
        return this.archiveFile.getName();
    }
}

