/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext.recognizer;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbext.FormatRecognizer;
import de.unirostock.sems.cbext.Formatizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.xml.bind.JAXBException;
import org.sbgn.SbgnUtil;
import org.xml.sax.SAXException;

public class SbgnRecognizer
extends FormatRecognizer {
    protected static int priority = 100;

    public static void setPriority(int newPriority) {
        if (priority < 0) {
            return;
        }
        priority = newPriority;
        Formatizer.resortRecognizers();
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public URI getFormatByParsing(File file, String mimeType) {
        if (mimeType == null || !mimeType.equals("application/xml")) {
            return null;
        }
        try {
            if (!SbgnUtil.isValid((File)file)) {
                throw new IOException("error parsing sbgn doc");
            }
            return SbgnRecognizer.buildUri("http://identifiers.org/combine.specifications/", "sbgn");
        }
        catch (IOException | JAXBException | SAXException e) {
            LOGGER.info((Exception)e, (Object[])new Object[]{"file ", file, " seems to be no sbgn file.."});
            return null;
        }
    }

    @Override
    public URI getFormatFromMime(String mime) {
        return null;
    }

    @Override
    public URI getFormatFromExtension(String extension) {
        if (extension != null && extension.equals("sbgn")) {
            return SbgnRecognizer.buildUri("http://identifiers.org/combine.specifications/", "sbgn");
        }
        return null;
    }
}

