/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext.recognizer;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbext.FormatRecognizer;
import de.unirostock.sems.cbext.Formatizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.jlibsedml.Libsedml;
import org.jlibsedml.SEDMLDocument;
import org.jlibsedml.SedMLError;
import org.jlibsedml.Version;
import org.jlibsedml.XMLException;

public class SedMlRecognizer
extends FormatRecognizer {
    protected static int priority = 100;

    public static void setPriority(int newPriority) {
        if (priority < 0) {
            return;
        }
        priority = newPriority;
        Formatizer.resortRecognizers();
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public URI getFormatByParsing(File file, String mimeType) {
        if (mimeType == null || !mimeType.equals("application/xml")) {
            return null;
        }
        try {
            SEDMLDocument doc = Libsedml.readDocument((File)file);
            doc.validate();
            if (doc.hasErrors()) {
                StringBuilder errors = new StringBuilder();
                for (SedMLError e : doc.getErrors()) {
                    if (e.getSeverity().compareTo((Enum)SedMLError.ERROR_SEVERITY.ERROR) < 0) continue;
                    errors.append("[" + e.getMessage() + "]");
                }
                if (errors.length() > 0) {
                    throw new IOException("error reading sedml file: " + errors.toString());
                }
            }
            Version v = doc.getVersion();
            return SedMlRecognizer.buildUri("http://identifiers.org/combine.specifications/", "sed-ml.level-" + v.getLevel() + ".version-" + v.getVersion());
        }
        catch (IOException | IllegalArgumentException | NullPointerException | XMLException e) {
            LOGGER.info((Exception)e, (Object[])new Object[]{"file ", file, " seems to be no sedml file.."});
            return null;
        }
    }

    @Override
    public URI getFormatFromMime(String mime) {
        return null;
    }

    @Override
    public URI getFormatFromExtension(String extension) {
        if (extension != null && extension.equals("sedml")) {
            return SedMlRecognizer.buildUri("http://identifiers.org/combine.specifications/", "sed-ml");
        }
        return null;
    }
}

