/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext.recognizer;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbext.FormatRecognizer;
import de.unirostock.sems.cbext.Formatizer;
import java.io.File;
import java.net.URI;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLReader;

public class SbmlRecognizer
extends FormatRecognizer {
    protected static int priority = 100;

    public static void setPriority(int newPriority) {
        if (priority < 0) {
            return;
        }
        priority = newPriority;
        Formatizer.resortRecognizers();
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public URI getFormatByParsing(File file, String mimeType) {
        if (mimeType == null || !mimeType.equals("application/xml")) {
            return null;
        }
        try {
            SBMLDocument doc = SBMLReader.read((File)file);
            return SbmlRecognizer.buildUri("http://identifiers.org/combine.specifications/", "sbml.level-" + doc.getLevel() + ".version-" + doc.getVersion());
        }
        catch (Exception e) {
            LOGGER.info((Exception)e, (Object[])new Object[]{"file ", file, " seems to be no sbml file.."});
            return null;
        }
    }

    @Override
    public URI getFormatFromMime(String mime) {
        return null;
    }

    @Override
    public URI getFormatFromExtension(String extension) {
        if (extension != null && extension != null && extension.equals("sbml")) {
            return SbmlRecognizer.buildUri("http://identifiers.org/combine.specifications/", "sbml");
        }
        return null;
    }
}

