/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbext.FormatRecognizer;
import de.unirostock.sems.cbext.recognizer.BioPaxRecognizer;
import de.unirostock.sems.cbext.recognizer.CellMlRecognizer;
import de.unirostock.sems.cbext.recognizer.DefaultRecognizer;
import de.unirostock.sems.cbext.recognizer.SbgnRecognizer;
import de.unirostock.sems.cbext.recognizer.SbmlRecognizer;
import de.unirostock.sems.cbext.recognizer.SbolRecognizer;
import de.unirostock.sems.cbext.recognizer.SedMlRecognizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Formatizer {
    private static List<FormatRecognizer> recognizerList = new ArrayList<FormatRecognizer>();
    public static URI GENERIC_UNKNOWN;

    public static void addFormatRecognizer(FormatRecognizer recognizer) {
        if (recognizer == null) {
            throw new IllegalArgumentException("The formatizer is not allowed to be null.");
        }
        recognizerList.add(recognizer);
        Formatizer.resortRecognizers();
    }

    public static void addDefaultRecognizers() {
        recognizerList.add(new SedMlRecognizer());
        recognizerList.add(new BioPaxRecognizer());
        recognizerList.add(new CellMlRecognizer());
        recognizerList.add(new SbgnRecognizer());
        recognizerList.add(new SbmlRecognizer());
        recognizerList.add(new SbolRecognizer());
        recognizerList.add(new DefaultRecognizer());
        Formatizer.resortRecognizers();
    }

    public static void removeRecognizers() {
        recognizerList.clear();
    }

    public static void resortRecognizers() {
        Collections.sort(recognizerList, new RecognizerComparator());
    }

    public static URI guessFormat(File file) {
        String ext;
        FormatRecognizer recognizer;
        if (file == null || !file.isFile()) {
            return null;
        }
        String mime = null;
        try {
            mime = Files.probeContentType(file.toPath());
        }
        catch (IOException e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"could not get mime from file " + file});
            return null;
        }
        URI format = null;
        Iterator<FormatRecognizer> iterator = recognizerList.iterator();
        while (iterator.hasNext() && (format = (recognizer = iterator.next()).getFormatByParsing(file, mime)) == null) {
        }
        if (format != null) {
            return format;
        }
        String name = file.getName();
        int dot = name.lastIndexOf(".");
        if (dot > 0 && ((ext = name.substring(dot + 1)).equals("sbml") || ext.equals("sedml") || ext.equals("sed-ml") || ext.equals("sbgn") || ext.equals("omex") || ext.equals("cellml") || ext.equals("biopax"))) {
            return Formatizer.getFormatFromExtension(ext);
        }
        return Formatizer.getFormatFromMime(mime);
    }

    public static URI getFormatFromMime(String mime) {
        FormatRecognizer recognizer;
        if (mime == null) {
            return GENERIC_UNKNOWN;
        }
        URI format = null;
        Iterator<FormatRecognizer> iterator = recognizerList.iterator();
        while (iterator.hasNext() && (format = (recognizer = iterator.next()).getFormatFromMime(mime)) == null) {
        }
        if (format != null) {
            return format;
        }
        return FormatRecognizer.buildUri("http://purl.org/NET/mediatypes/", mime, GENERIC_UNKNOWN);
    }

    public static URI getFormatFromExtension(String extension) {
        FormatRecognizer recognizer;
        if (extension == null) {
            return GENERIC_UNKNOWN;
        }
        URI format = null;
        Iterator<FormatRecognizer> iterator = recognizerList.iterator();
        while (iterator.hasNext() && (format = (recognizer = iterator.next()).getFormatFromExtension(extension)) == null) {
        }
        if (format != null) {
            return format;
        }
        return GENERIC_UNKNOWN;
    }

    static {
        String defaultUri = "http://purl.org/NET/mediatypes/application/x.unknown";
        try {
            GENERIC_UNKNOWN = new URI(defaultUri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            LOGGER.error((Exception)e, (Object[])new Object[]{"error generating generic default uri: ", defaultUri});
        }
        Formatizer.addDefaultRecognizers();
    }

    private static class RecognizerComparator
    implements Comparator<FormatRecognizer> {
        private RecognizerComparator() {
        }

        @Override
        public int compare(FormatRecognizer o1, FormatRecognizer o2) {
            return o2.getPriority() - o1.getPriority();
        }
    }
}

