/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext.recognizer;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.bives.cellml.algorithm.CellMLValidator;
import de.unirostock.sems.cbext.FormatRecognizer;
import de.unirostock.sems.cbext.Formatizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class CellMlRecognizer
extends FormatRecognizer {
    protected static int priority = 100;

    public static void setPriority(int newPriority) {
        if (priority < 0) {
            return;
        }
        priority = newPriority;
        Formatizer.resortRecognizers();
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public URI getFormatByParsing(File file, String mimeType) {
        if (mimeType == null || !mimeType.equals("application/xml")) {
            return null;
        }
        try {
            CellMLValidator validator = new CellMLValidator();
            if (!validator.validate(file)) {
                throw new IOException("error parsing cellml doc: " + validator.getError().getMessage());
            }
            return CellMlRecognizer.buildUri("http://identifiers.org/combine.specifications/", "cellml");
        }
        catch (IOException e) {
            LOGGER.info((Exception)e, (Object[])new Object[]{"file ", file, " seems to be no cellml file.."});
            return null;
        }
    }

    @Override
    public URI getFormatFromMime(String mime) {
        return null;
    }

    @Override
    public URI getFormatFromExtension(String extension) {
        if (extension != null && extension.equals("cellml")) {
            return CellMlRecognizer.buildUri("http://identifiers.org/combine.specifications/", "cellml");
        }
        return null;
    }
}

