/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext.recognizer;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbext.FormatRecognizer;
import de.unirostock.sems.cbext.Formatizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.sbolstandard.core.SBOLFactory;
import org.sbolstandard.core.SBOLValidationException;

public class SbolRecognizer
extends FormatRecognizer {
    protected static int priority = 100;

    public static void setPriority(int newPriority) {
        if (priority < 0) {
            return;
        }
        priority = newPriority;
        Formatizer.resortRecognizers();
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public URI getFormatByParsing(File file, String mimeType) {
        if (mimeType == null || !mimeType.equals("application/xml")) {
            return null;
        }
        try {
            SBOLFactory.read((InputStream)new FileInputStream(file));
            return SbolRecognizer.buildUri("http://identifiers.org/combine.specifications/", "sbol");
        }
        catch (IOException | SBOLValidationException e) {
            LOGGER.info((Exception)e, (Object[])new Object[]{"file ", file, " seems to be no sbol file.."});
            return null;
        }
    }

    @Override
    public URI getFormatFromMime(String mime) {
        return null;
    }

    @Override
    public URI getFormatFromExtension(String extension) {
        if (extension != null && extension.equals("sbol")) {
            return SbolRecognizer.buildUri("http://identifiers.org/combine.specifications/", "sbol");
        }
        return null;
    }
}

