/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext.recognizer;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbext.FormatRecognizer;
import de.unirostock.sems.cbext.Formatizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.BioPaxIOException;

public class BioPaxRecognizer
extends FormatRecognizer {
    protected static int priority = 100;

    public static void setPriority(int newPriority) {
        if (priority < 0) {
            return;
        }
        priority = newPriority;
        Formatizer.resortRecognizers();
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public URI getFormatByParsing(File file, String mimeType) {
        if (mimeType == null || !mimeType.equals("application/rdf+xml")) {
            return null;
        }
        try {
            SimpleIOHandler handler = new SimpleIOHandler();
            Model model = handler.convertFromOWL((InputStream)new FileInputStream(file));
            return BioPaxRecognizer.buildUri("http://identifiers.org/combine.specifications/", "biopax");
        }
        catch (IOException | BioPaxIOException e) {
            LOGGER.info((Exception)e, (Object[])new Object[]{"file ", file, " seems to be no biopax file.."});
            return null;
        }
    }

    @Override
    public URI getFormatFromMime(String mime) {
        return null;
    }

    @Override
    public URI getFormatFromExtension(String extension) {
        if (extension != null && extension.equals("biopax")) {
            return BioPaxRecognizer.buildUri("http://identifiers.org/combine.specifications/", "biopax");
        }
        return null;
    }
}

