/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext;

import de.unirostock.sems.cbext.IconCollection;
import de.unirostock.sems.cbext.collections.DefaultIconCollection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Iconizer {
    private static List<IconCollection> iconCollectionsList = new ArrayList<IconCollection>();
    public static final String GENERIC_UNKNOWN = "Blue-unknown.png";

    public static void addIconCollection(IconCollection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("The mapper is not allowed to be null.");
        }
        iconCollectionsList.add(collection);
        Collections.sort(iconCollectionsList, new IconCollectionComparator());
    }

    public static void addDefaultCollection() {
        iconCollectionsList.add(new DefaultIconCollection());
        Iconizer.resortCollections();
    }

    public static void removeCollections() {
        iconCollectionsList.clear();
    }

    public static void resortCollections() {
        Collections.sort(iconCollectionsList, new IconCollectionComparator());
    }

    public static String formatToIcon(URI format) {
        IconCollection mapper;
        if (format == null) {
            return GENERIC_UNKNOWN;
        }
        String name = null;
        Iterator<IconCollection> iterator = iconCollectionsList.iterator();
        while (iterator.hasNext() && (name = (mapper = iterator.next()).formatToIconName(format)) == null) {
        }
        return name != null ? name : GENERIC_UNKNOWN;
    }

    public static URL formatToIconUrl(URI format) {
        IconCollection mapper;
        if (format == null) {
            return Iconizer.class.getResource("/icons/Blue-unknown.png");
        }
        URL url = null;
        Iterator<IconCollection> iterator = iconCollectionsList.iterator();
        while (iterator.hasNext() && (url = (mapper = iterator.next()).formatToIconUrl(format)) == null) {
        }
        return url != null ? url : Iconizer.class.getResource("/icons/Blue-unknown.png");
    }

    public static InputStream formatToIconStream(URI format) {
        IconCollection mapper;
        if (format == null) {
            return Iconizer.class.getResourceAsStream("/icons/Blue-unknown.png");
        }
        InputStream url = null;
        Iterator<IconCollection> iterator = iconCollectionsList.iterator();
        while (iterator.hasNext() && (url = (mapper = iterator.next()).formatToIconStream(format)) == null) {
        }
        return url != null ? url : Iconizer.class.getResourceAsStream("/icons/Blue-unknown.png");
    }

    public File extractIconExample() throws IOException, URISyntaxException {
        URI format = new URI("http://identifiers.org/combine.specifications/sbml");
        String iconName = Iconizer.formatToIcon(format);
        System.out.println("icon name: " + iconName);
        File expectedFile = new File("/tmp/" + iconName);
        if (!expectedFile.exists()) {
            InputStream fin = Iconizer.formatToIconStream(format);
            FileOutputStream fout = new FileOutputStream(expectedFile);
            byte[] b = new byte[1024];
            int noOfBytes = 0;
            while ((noOfBytes = fin.read(b)) != -1) {
                fout.write(b, 0, noOfBytes);
            }
            System.out.println("File copied!");
            fin.close();
            fout.close();
        } else {
            System.out.println("file extracted previously");
        }
        System.out.println("icon can be found in " + expectedFile.getAbsolutePath());
        return expectedFile;
    }

    static {
        Iconizer.addDefaultCollection();
    }

    private static class IconCollectionComparator
    implements Comparator<IconCollection> {
        private IconCollectionComparator() {
        }

        @Override
        public int compare(IconCollection o1, IconCollection o2) {
            return o2.getPriority() - o1.getPriority();
        }
    }
}

