/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext.collections;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbext.IconCollection;
import de.unirostock.sems.cbext.Iconizer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.Set;

public class DefaultIconCollection
extends IconCollection {
    protected static int priority = 100;
    private static final String FORMAT2ICON_NAME = "/format2icon.prop";
    private static final String ICON_DIR = "/icons/";
    protected Properties format2Icon = new Properties();

    public static void setPriority(int newPriority) {
        if (priority < 0) {
            return;
        }
        priority = newPriority;
        Iconizer.resortCollections();
    }

    @Override
    public int getPriority() {
        return priority;
    }

    public DefaultIconCollection() {
        try {
            InputStream input = DefaultIconCollection.class.getResourceAsStream(FORMAT2ICON_NAME);
            this.format2Icon.load(input);
            input.close();
        }
        catch (IOException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"error reading known formats: ", DefaultIconCollection.class.getResourceAsStream(FORMAT2ICON_NAME)});
        }
    }

    @Override
    public boolean hasIcon(URI format) {
        return this.format2Icon.getProperty(format.toString()) != null;
    }

    @Override
    public URL formatToIconUrl(URI format) {
        String name = this.formatToIconName(format);
        if (name != null) {
            return DefaultIconCollection.class.getResource(ICON_DIR + name);
        }
        return null;
    }

    @Override
    public InputStream formatToIconStream(URI format) {
        String name = this.formatToIconName(format);
        if (name != null) {
            return DefaultIconCollection.class.getResourceAsStream(ICON_DIR + name);
        }
        return null;
    }

    @Override
    public String formatToIconName(URI format) {
        return this.format2Icon.getProperty(format.toString(), null);
    }

    public Set<Object> getAvailableFormatIcons() {
        return this.format2Icon.keySet();
    }
}

