/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext.recognizer;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbext.FormatRecognizer;
import de.unirostock.sems.cbext.Formatizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;

public class DefaultRecognizer
extends FormatRecognizer {
    protected static int priority = 100;
    private static final String EXT2FORMAT_NAME = "/ext2format.prop";
    private Properties ext2Format = new Properties();

    public static void setPriority(int newPriority) {
        if (priority < 0) {
            return;
        }
        priority = newPriority;
        Formatizer.resortRecognizers();
    }

    @Override
    public int getPriority() {
        return priority;
    }

    public DefaultRecognizer() {
        try {
            InputStream input = DefaultRecognizer.class.getResourceAsStream(EXT2FORMAT_NAME);
            this.ext2Format.load(input);
            input.close();
        }
        catch (IOException e) {
            LOGGER.error((Exception)e, (Object[])new Object[]{"error reading known formats: ", DefaultRecognizer.class.getResourceAsStream(EXT2FORMAT_NAME)});
        }
    }

    @Override
    public URI getFormatFromMime(String mime) {
        if (mime == null) {
            return null;
        }
        String uriString = this.ext2Format.getProperty(mime, null);
        if (uriString != null) {
            return FormatRecognizer.buildUri(uriString, "");
        }
        return null;
    }

    @Override
    public URI getFormatFromExtension(String extension) {
        return this.getFormatFromMime(extension);
    }

    @Override
    public URI getFormatByParsing(File file, String mimeType) {
        return null;
    }
}

