/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext.pharmml;

import de.binfalse.bflog.LOGGER;
import de.unirostock.sems.cbext.FormatRecognizer;
import eu.ddmore.libpharmml.ILibPharmML;
import eu.ddmore.libpharmml.IPharmMLResource;
import eu.ddmore.libpharmml.IPharmMLValidator;
import eu.ddmore.libpharmml.IValidationReport;
import eu.ddmore.libpharmml.PharmMlFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class PharmMlRecognizer
extends FormatRecognizer {
    public static int priority = 120;

    public int getPriority() {
        return priority;
    }

    public URI getFormatByParsing(File file, String mimeType) {
        if (mimeType == null || !mimeType.equals("application/xml")) {
            return null;
        }
        try {
            ILibPharmML libPharmML = PharmMlFactory.getInstance().createLibPharmML();
            FileInputStream in = new FileInputStream(file);
            IPharmMLResource resource = libPharmML.createDomFromResource((InputStream)in);
            IPharmMLValidator validator = libPharmML.getValidator();
            IValidationReport rpt = validator.createValidationReport(resource);
            if (rpt.isValid()) {
                return PharmMlRecognizer.buildUri((String)"http://identifiers.org/combine.specifications/", (String)"pharmml");
            }
        }
        catch (IOException e) {
            LOGGER.info((Exception)e, (Object[])new Object[]{"file ", file, " seems to be no PhramML file.."});
        }
        catch (Exception e) {
            LOGGER.warn((Exception)e, (Object[])new Object[]{"pharmml could not parse file ", file});
        }
        return null;
    }

    public URI getFormatFromMime(String mime) {
        return null;
    }

    public URI getFormatFromExtension(String extension) {
        if (extension != null && extension != null && extension.equals("pharmml")) {
            return PharmMlRecognizer.buildUri((String)"http://identifiers.org/combine.specifications/", (String)"pharmml");
        }
        return null;
    }
}

