/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.cbext.pharmml;

import de.unirostock.sems.cbext.FormatRecognizer;
import de.unirostock.sems.cbext.Formatizer;
import de.unirostock.sems.cbext.IconCollection;
import de.unirostock.sems.cbext.Iconizer;
import de.unirostock.sems.cbext.pharmml.PharmMlIcon;
import de.unirostock.sems.cbext.pharmml.PharmMlRecognizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class Demo {
    public void demo() throws IOException {
        File pharmmlFile = new File("test/vancauter_v1.xml");
        URI format = Formatizer.guessFormat((File)pharmmlFile);
        System.out.println("the format of file " + pharmmlFile + " is recognized as " + format);
        System.out.println("adding this extension to recognize PharmML");
        Formatizer.addFormatRecognizer((FormatRecognizer)new PharmMlRecognizer());
        format = Formatizer.guessFormat((File)pharmmlFile);
        System.out.println("the format of file " + pharmmlFile + " is recognized as " + format);
        System.out.println("icon name for pharmml filesw/o this extension: " + Iconizer.formatToIcon((URI)format));
        System.out.println("adding this extension to provide an icon for PharmML");
        Iconizer.addIconCollection((IconCollection)new PharmMlIcon());
        System.out.println("icon name for pharmml files w/ this extension: " + Iconizer.formatToIcon((URI)format));
        File tmpIcon = File.createTempFile("pharmml", ".png");
        InputStream fin = Iconizer.formatToIconStream((URI)format);
        FileOutputStream fout = new FileOutputStream(tmpIcon);
        byte[] b = new byte[1024];
        int noOfBytes = 0;
        while ((noOfBytes = fin.read(b)) != -1) {
            fout.write(b, 0, noOfBytes);
        }
        System.out.println("extracted icon to " + tmpIcon);
        fin.close();
        fout.close();
    }
}

