/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.docompiler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.taverna.robundle.Bundle;
import org.apache.taverna.robundle.Bundles;
import org.apache.taverna.robundle.manifest.Manifest;
import org.apache.taverna.robundle.manifest.PathAnnotation;
import org.apache.taverna.robundle.manifest.PathMetadata;

public class Compiler {
    public static boolean DIE = true;
    public static final String ROOT_DOC_ANNOTAION = "http://binfalse.de#rootdocument";

    public static final void die(String message) {
        System.err.println("!!! " + message);
        System.err.println();
        String cmd = System.getProperty("sun.java.command");
        if (cmd.endsWith(".jar")) {
            System.out.print("USAGE: java -jar " + cmd);
        } else {
            System.out.print("USAGE: java -classpath CLASSPATH " + cmd);
        }
        System.out.println(" DOCUMENT_OBJECT");
        System.out.println("\tDOCUMENT_OBJECT\tthe research object containing the latex project");
        if (DIE) {
            System.exit(2);
        }
    }

    public static final String extractResearchObject(Bundle bundle, Path targetDir) throws IOException {
        Manifest mf = bundle.getManifest();
        List aggr = mf.getAggregates();
        for (PathMetadata pm : aggr) {
            if (pm.getFile() == null) continue;
            System.out.println("  > " + pm.getFile());
            String cur = pm.getFile().toString();
            Path target = targetDir.resolve(cur.substring(1));
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(pm.getFile(), target, new CopyOption[0]);
        }
        List annotations = mf.getAnnotations();
        for (PathAnnotation annotation : annotations) {
            if (!annotation.getContent().toString().equals(ROOT_DOC_ANNOTAION)) continue;
            return annotation.getAbout().toString();
        }
        return null;
    }

    public static final boolean compileLatex(Path sourceDirectory, String texFile, Path logFile) throws IOException, InterruptedException {
        String line;
        ProcessBuilder pb = new ProcessBuilder("latexmk", "-pdf", "-f", "-pdflatex=pdflatex -shell-escape -interaction=nonstopmode", texFile).redirectErrorStream(true).directory(sourceDirectory.toFile());
        Process p = pb.start();
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedWriter bw = new BufferedWriter(new FileWriter(logFile.toFile()));
        while ((line = br.readLine()) != null) {
            bw.write(line);
            bw.newLine();
        }
        br.close();
        bw.close();
        return p.waitFor() == 0;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Path finalPdf;
        if (args == null || args.length != 1) {
            Compiler.die("expect exactly one argument: the document object");
            return;
        }
        Path tmpDir = Files.createTempDirectory("documentObject", new FileAttribute[0]);
        System.out.println(">>> tmp dir is: " + tmpDir);
        Path file = new File(args[0]).toPath();
        if (!Files.exists(file, new LinkOption[0])) {
            Compiler.die("file " + file + " does not exist");
            return;
        }
        System.out.println(">>> extracting research object " + file + " to " + tmpDir);
        String texFile = null;
        try (Bundle bundle = Bundles.openBundleReadOnly((Path)file);){
            texFile = Compiler.extractResearchObject(bundle, tmpDir);
        }
        if (texFile == null || !texFile.endsWith(".tex")) {
            Compiler.die("could not find valid tex file (" + texFile + ")");
            return;
        }
        while (texFile.startsWith("/")) {
            texFile = texFile.substring(1);
        }
        if (!Files.exists(tmpDir.resolve(texFile), new LinkOption[0])) {
            Compiler.die("root tex file does not exist (" + texFile + ")");
            return;
        }
        Path logFile = file.getParent().resolve(texFile.substring(0, texFile.length() - 4) + ".outlog");
        if (Files.exists(logFile, new LinkOption[0])) {
            Compiler.die("log file exists. won't override it: " + logFile);
        }
        System.out.println(">>> compiler log will be available in " + logFile);
        String pdfFile = texFile.substring(0, texFile.length() - 4) + ".pdf";
        if (Compiler.compileLatex(tmpDir, texFile, logFile)) {
            finalPdf = file.getParent().resolve(pdfFile);
            if (Files.exists(finalPdf, new LinkOption[0])) {
                Compiler.die("target pdf file exists. won't override it: " + finalPdf);
            }
        } else {
            Compiler.die("compiling document object failed");
            return;
        }
        Files.copy(tmpDir.resolve(pdfFile), finalPdf, new CopyOption[0]);
        System.out.println(">>> final pdf will be available in " + finalPdf);
        System.out.println(">>> compilation done.");
    }
}

