/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.databases.Interface;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.unirostock.sems.ModelCrawler.databases.Interface.Change;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ChangeSet {
    @JsonIgnore
    private final Log log = LogFactory.getLog(ChangeSet.class);
    protected String fileId;
    protected NavigableSet<Change> changes = new TreeSet<Change>();

    public Set<Change> getChanges() {
        return this.changes;
    }

    public Change getLatestChange() {
        if (this.changes.size() > 0) {
            return (Change)this.changes.last();
        }
        return null;
    }

    public void addChange(Change change) {
        if (change.getFileId().equals(this.fileId)) {
            this.changes.add(change);
        }
    }

    public ChangeSet(URL repositoryUrl, String filePath) {
        try {
            this.fileId = Change.generateFileId(repositoryUrl, filePath);
        }
        catch (URISyntaxException e) {
            this.log.fatal((Object)"Exception while generation fileId", (Throwable)e);
        }
    }

    public ChangeSet(String fileId) {
        this.fileId = fileId;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String toString() {
        return "CS:" + this.fileId + "-" + this.changes.size();
    }
}

