/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.databases.PMR2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.unirostock.sems.ModelCrawler.Config;
import de.unirostock.sems.ModelCrawler.databases.Interface.Change;
import de.unirostock.sems.ModelCrawler.databases.Interface.ChangeSet;
import de.unirostock.sems.ModelCrawler.databases.Interface.ModelDatabase;
import de.unirostock.sems.ModelCrawler.databases.PMR2.PmrChange;
import de.unirostock.sems.ModelCrawler.databases.PMR2.PmrChangeSet;
import de.unirostock.sems.ModelCrawler.databases.PMR2.RelevantFile;
import de.unirostock.sems.ModelCrawler.databases.PMR2.exceptions.HttpException;
import de.unirostock.sems.ModelCrawler.exceptions.StorageException;
import de.unirostock.sems.ModelCrawler.helper.CrawledModelRecord;
import de.unirostock.sems.bives.tools.DocumentClassifier;
import de.unirostock.sems.morre.client.exception.MorreCommunicationException;
import de.unirostock.sems.morre.client.exception.MorreException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hamnaberg.json.Collection;
import net.hamnaberg.json.Link;
import net.hamnaberg.json.parser.CollectionParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;

public class PmrDb
extends ModelDatabase {
    private static final long serialVersionUID = -5332599172641988743L;
    @JsonIgnore
    private final Log log = LogFactory.getLog(PmrDb.class);
    protected String hashAlgo = "MD5";
    protected URL repoListUrl = null;
    protected URL collectionEndpoint = null;
    @JsonIgnore
    protected DocumentClassifier classifier = null;
    @JsonIgnore
    protected Set<String> fileExtensionBlacklist = new HashSet<String>();
    @JsonIgnore
    protected Map<String, ChangeSet> changeSetMap = new HashMap<String, ChangeSet>();
    @JsonIgnore
    protected WorkingDirConfig config = null;
    private File workingDir;

    @Override
    public List<String> listModels() {
        return new ArrayList<String>(this.changeSetMap.keySet());
    }

    @Override
    public Map<String, ChangeSet> listChanges() {
        return this.changeSetMap;
    }

    @Override
    public ChangeSet getModelChanges(String fileId) {
        return this.changeSetMap.get(fileId);
    }

    public String getHashAlgo() {
        return this.hashAlgo;
    }

    public void setHashAlgo(String hashAlgo) {
        this.hashAlgo = hashAlgo;
    }

    public URL getRepoListUrl() {
        return this.repoListUrl;
    }

    public void setRepoListUrl(URL repoListUri) {
        this.repoListUrl = repoListUri;
    }

    public URL getCollectionEndpoint() {
        return this.collectionEndpoint;
    }

    public void setCollectionEndpoint(URL collectionEndpoint) {
        this.collectionEndpoint = collectionEndpoint;
    }

    @Override
    public void close() {
        this.saveProperties();
        try {
            FileUtils.deleteDirectory((File)this.tempDir);
        }
        catch (IOException e) {
            this.log.error((Object)"Error while cleaning up the temp dir!", (Throwable)e);
        }
    }

    @Override
    public Map<String, ChangeSet> call() {
        LinkedHashSet<String> repositories = null;
        if (this.morreClient == null && Config.getWorkingMode() != Config.WorkingMode.NO_MORRE) {
            this.log.error((Object)"No Morre crawler interface provided!");
            throw new IllegalArgumentException("No Morre crawler interface provided!");
        }
        this.classifier = new DocumentClassifier();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Started BiVeS Classifier");
        }
        this.init();
        this.log.info((Object)"Start crawling the PMR2 Database by going throw the Mercurial Workspaces");
        try {
            if (this.repoListUrl != null) {
                if (this.repoListUrl != null && !this.repoListUrl.getProtocol().toLowerCase().startsWith("http")) {
                    throw new IllegalArgumentException("Only http is supported for the Repository List at the moment!");
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)MessageFormat.format("Init new PMR2 Connector based on Repolist: {0}", this.repoListUrl));
                }
                repositories = this.getRepositoryList();
            }
            if (this.collectionEndpoint != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)MessageFormat.format("Init new PMR2 Connector based on Collection+JSON: {0}", this.collectionEndpoint));
                }
                if (repositories == null) {
                    repositories = this.getRepositoriesFromCollection();
                } else {
                    repositories.addAll(this.getRepositoriesFromCollection());
                }
            } else {
                this.log.fatal((Object)"No suitable endpoint was passed");
            }
        }
        catch (HttpException e) {
            this.log.fatal((Object)"Can not download RepositoryList", (Throwable)e);
        }
        if (this.limit > 0) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)MessageFormat.format("Limit processed Repositories to {0}", this.limit));
            }
            LinkedHashSet<String> newRepositoryList = new LinkedHashSet<String>(this.limit);
            for (String repo : repositories) {
                newRepositoryList.add(repo);
                if (newRepositoryList.size() < this.limit) continue;
                break;
            }
            repositories = newRepositoryList;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("Iterate over {0} repositories", repositories.size()));
        }
        for (String repoLink : repositories) {
            this.processRepository(repoLink);
        }
        this.log.info((Object)"Finished crawling PMR2 Database.");
        return this.changeSetMap;
    }

    protected void init() {
        this.workingDir = this.obtainWorkingDir();
        this.log.trace((Object)("Preparing working dir " + this.workingDir.getAbsolutePath()));
        if (!this.workingDir.exists()) {
            this.workingDir.mkdirs();
        }
        this.createTempDir();
        try {
            this.log.info((Object)"Loading working dir config");
            File configFile = new File(this.workingDir, Config.getConfig().getWorkingDirConfig());
            this.config = configFile.exists() ? (WorkingDirConfig)Config.getObjectMapper().readValue(configFile, WorkingDirConfig.class) : new WorkingDirConfig();
        }
        catch (IOException e) {
            this.log.fatal((Object)"IOException while reading the workingdir config file", (Throwable)e);
        }
        this.fileExtensionBlacklist.addAll(Arrays.asList(Config.getConfig().getExtensionBlacklist()));
    }

    protected File getTempFile() {
        File temp = new File(this.tempDir, UUID.randomUUID().toString());
        while (temp.exists()) {
            temp = new File(this.tempDir, UUID.randomUUID().toString());
        }
        return temp;
    }

    protected void saveProperties() {
        if (this.config == null) {
            this.config = new WorkingDirConfig();
        }
        try {
            this.log.info((Object)"Saving working dir config");
            File configFile = new File(this.workingDir, Config.getConfig().getWorkingDirConfig());
            Config.getObjectMapper().writeValue(configFile, (Object)this.config);
            this.log.info((Object)"working dir config saved!");
        }
        catch (IOException e) {
            this.log.error((Object)"Can not write the workingDir config file!", (Throwable)e);
        }
    }

    protected LinkedHashSet<String> getRepositoryList() throws HttpException {
        LinkedHashSet<String> repoList = new LinkedHashSet<String>();
        try {
            InputStream input = this.repoListUrl.openStream();
            Scanner scanner = new Scanner(input);
            scanner.useDelimiter("\n");
            while (scanner.hasNext()) {
                String repo = scanner.next();
                if (repo == null || repo.isEmpty()) continue;
                repoList.add(repo);
            }
            scanner.close();
        }
        catch (IOException e) {
            throw new HttpException("IOException while downloading RepositoryList", e);
        }
        return repoList;
    }

    protected LinkedHashSet<String> getRepositoriesFromCollection() throws HttpException {
        LinkedHashSet<String> repoList = null;
        try {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(30);
            LinkedList<Future<URL>> futures = new LinkedList<Future<URL>>();
            Collection expose = this.getCollection(this.collectionEndpoint);
            for (Link link : expose.getLinks()) {
                ExposureTransformJob job = new ExposureTransformJob(link.getHref().toURL());
                futures.add(executor.submit(job));
            }
            executor.shutdown();
            while (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.log.debug((Object)"Awaiting completion of URL transformation");
            }
            repoList = new LinkedHashSet<String>(futures.size() / 2);
            for (Future future : futures) {
                try {
                    if (!future.isDone() || future.get() == null) continue;
                    repoList.add(((URL)future.get()).toString());
                }
                catch (ExecutionException e) {
                    this.log.warn((Object)"ExecutionException occured!", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            throw new HttpException("IOException while getting exposure list", e);
        }
        catch (InterruptedException e) {
            throw new HttpException("Was interrupted while waiting for completion of URL transformation", e);
        }
        return repoList;
    }

    protected Collection getCollection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.connect();
        String contentType = connection.getContentType();
        if (contentType == null || !contentType.startsWith("application/vnd.") && !contentType.equals("application/json")) {
            throw new IOException("Returned message is not Collection+JSON");
        }
        return new CollectionParser().parse(connection.getInputStream());
    }

    protected URL transformExposureUrl(URL link) {
        try {
            InputStream exposureStream = link.openStream();
            String source = IOUtils.toString((InputStream)exposureStream);
            Pattern gitClonePattern = Pattern.compile("<input [^>]*value=.git clone ([^'\"]*). ");
            Matcher matcher = gitClonePattern.matcher(source);
            if (matcher.find()) {
                String newLink = matcher.group(1);
                this.log.debug((Object)MessageFormat.format("resolved exposure url {0} to {1}", link, newLink));
                return new URL(newLink);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Exception while transforming " + link.toString() + " to workspace link"), (Throwable)e);
        }
        return null;
    }

    protected File makeRepositoryDirectory(String repository) {
        File directory = null;
        String name = null;
        String repoHash = this.calculateRepositoryHash(repository);
        directory = this.getRepositoryDirectory(repository);
        if (directory == null) {
            name = repository.substring(repository.lastIndexOf(47)) + "_" + repository.hashCode();
            directory = new File(this.workingDir, name);
            if (directory.exists() && directory.isDirectory()) {
                String newName = name;
                int i = 2;
                do {
                    newName = name + "_" + i;
                    directory = new File(this.workingDir, newName);
                    ++i;
                } while (directory.exists());
                name = newName;
            }
            this.config.getRepositories().put(repoHash, name);
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    protected File getRepositoryDirectory(String repository) {
        String repoHash = this.calculateRepositoryHash(repository);
        String name = null;
        name = this.config.getRepositories().get(repoHash);
        if (name != null) {
            return new File(this.workingDir, name);
        }
        return null;
    }

    private String calculateRepositoryHash(String repository) {
        String repoHash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance(this.hashAlgo);
            digest.update(repository.getBytes());
            repoHash = new BigInteger(digest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.fatal((Object)MessageFormat.format("Can not calc Repository Hash for {0}!", repository), (Throwable)e);
        }
        return repoHash;
    }

    protected void processRepository(String repoLink) {
        File location;
        Git repo = null;
        boolean hasChanges = false;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("Check Repository {0}", repoLink));
        }
        if ((location = this.getRepositoryDirectory(repoLink)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)MessageFormat.format("Repository {0} is unknown. Create new folder and clone it", repoLink));
            }
            try {
                location = this.makeRepositoryDirectory(repoLink);
                repo = Git.cloneRepository().setURI(repoLink).setDirectory(location).setCloneSubmodules(true).call();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)MessageFormat.format("Repository {0} has been cloned into {1}", repoLink, location.getAbsolutePath()));
                }
                hasChanges = true;
            }
            catch (GitAPIException e) {
                this.log.error((Object)MessageFormat.format("Can not clone Git Repository {0} into {1}", repoLink, location.getAbsolutePath()), (Throwable)e);
                return;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)MessageFormat.format("Repository {0} is known. Perform a Pull-Request into local copy {1}", repoLink, location.getAbsolutePath()));
        }
        try {
            repo = Git.open((File)location);
            repo.checkout().setName("master").call();
            PullResult pullResult = repo.pull().call();
            if (!pullResult.isSuccessful()) {
                this.log.warn((Object)MessageFormat.format("Pull request failed! from {0} into {1} ", repoLink, location.getAbsolutePath()));
                hasChanges = false;
            } else {
                hasChanges = pullResult.getFetchResult().getTrackingRefUpdates().size() > 0;
            }
        }
        catch (IOException | GitAPIException e) {
            this.log.error((Object)MessageFormat.format("Can not pull Git Repository {0} into {1}", repoLink, location.getAbsolutePath()), e);
            return;
        }
        if (this.log.isInfoEnabled()) {
            if (hasChanges) {
                this.log.info((Object)MessageFormat.format("Pulled changes from {0} into local copy {1}", repoLink, location.getAbsolutePath()));
            } else {
                this.log.info((Object)"No changes to pull. Local copy is up to date.");
            }
        }
        if (hasChanges) {
            this.scanAndTransferRepository(repoLink, location, repo);
        }
        if (repo != null) {
            repo.close();
        }
    }

    protected void scanAndTransferRepository(String repoUrl, File location, Git repo) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("Start scanning {0} for changes", repoUrl));
        }
        List<RelevantFile> relevantFiles = this.scanRepository(location);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("Found {0} relevant files.", relevantFiles.size()));
        }
        try {
            for (RelevantFile file : relevantFiles) {
                file.generateFileId(repoUrl);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)MessageFormat.format("Generated fileId {0} for file {1}", file.getFileId(), file.getFilePath()));
                }
                this.searchLatestKnownVersion(file);
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.log.fatal((Object)"Unsupported Encoding. Can not generate fileId", (Throwable)e);
        }
        List<RevCommit> relevantVersions = this.detectRelevantVersions(repo, relevantFiles);
        if (relevantVersions == null) {
            return;
        }
        try {
            this.iterateRelevantVersions(repo, location, relevantFiles, relevantVersions);
        }
        catch (IOException e) {
            this.log.fatal((Object)MessageFormat.format("IOException while iteration throw relevant Versions in {0}", location), (Throwable)e);
        }
        for (RelevantFile file : relevantFiles) {
            if (file.getChangeSet() == null) continue;
            this.changeSetMap.put(file.getFileId(), file.getChangeSet());
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)"-------------------------------");
            this.log.debug((Object)("  next element " + file.getFileId()));
            this.log.debug((Object)"    has associated changeset:");
            PmrChangeSet elementChangeSet = file.getChangeSet();
            for (Change c : elementChangeSet.getChanges()) {
                this.log.debug((Object)("      repository URL " + c.getChangeRepositoryUrl(c)));
                this.log.debug((Object)("      file path " + c.getChangeFilePath(c)));
                this.log.debug((Object)("      file name " + c.getChangeFileName(c)));
                this.log.debug((Object)("      version ID " + c.getChangeVersionId(c)));
                this.log.debug((Object)("      version date " + c.getChangeVersionDate(c)));
                this.log.debug((Object)("      crawled date " + c.getChangeCrawledDate(c)));
                this.log.debug((Object)"-------------------------------");
            }
        }
    }

    protected List<RelevantFile> scanRepository(File location) {
        LinkedList<RelevantFile> relevantFiles = new LinkedList<RelevantFile>();
        this.scanRepositoryDir(location, location, relevantFiles);
        return relevantFiles;
    }

    private void scanRepositoryDir(File base, File dir, List<RelevantFile> relevantFiles) {
        String[] entries;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)MessageFormat.format("Scanning {0}", base));
        }
        if ((entries = dir.list()) == null) {
            return;
        }
        for (int index = 0; index < entries.length; ++index) {
            File entry = new File(dir, entries[index]);
            if (entry.isDirectory() && entry.exists() && !entry.getName().startsWith(".")) {
                this.scanRepositoryDir(base, entry, relevantFiles);
                continue;
            }
            if (!entry.isFile() || !entry.exists()) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)MessageFormat.format("Found {0}. Check relevance...", entry));
            }
            if (this.fileExtensionBlacklist.contains(FilenameUtils.getExtension((String)entry.getName()))) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)"file extension is blacklisted. Skip this file...");
                continue;
            }
            RelevantFile file = this.isRelevant(base, entry);
            if (file != null) {
                relevantFiles.add(file);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)"Is relevant. Adds it.");
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)"Is not relevant.");
        }
    }

    private RelevantFile isRelevant(File base, File model) {
        int type = 0;
        RelevantFile relevantFile = null;
        type = this.classifier.classify(model);
        if ((type & 1) > 0 && ((type & 2) > 0 || (type & 4) > 0)) {
            Path basePath = Paths.get(base.toString(), new String[0]);
            Path modelPath = Paths.get(model.toString(), new String[0]);
            Path relativPath = basePath.relativize(modelPath);
            relevantFile = new RelevantFile(relativPath.toString());
            relevantFile.setType(type);
        }
        return relevantFile;
    }

    protected void searchLatestKnownVersion(RelevantFile relevantFile) {
        String versionId = null;
        Date versionDate = null;
        ChangeSet changeSet = null;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("Searches latest known version for model {0}", relevantFile.getFileId()));
        }
        if ((changeSet = this.changeSetMap.get(relevantFile.getFileId())) != null) {
            Change latestChange;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"ChangeSet available");
            }
            if ((latestChange = changeSet.getLatestChange()) != null) {
                versionId = latestChange.getVersionId();
                versionDate = latestChange.getVersionDate();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"But no change setted");
            }
        }
        if (versionId == null && versionDate == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Start database request");
            }
            CrawledModelRecord latest = null;
            try {
                latest = Config.getWorkingMode() == Config.WorkingMode.NO_MORRE ? null : CrawledModelRecord.extendDataholder(this.morreClient.getLatestModelVersion(relevantFile.getFileId()));
            }
            catch (MorreCommunicationException e) {
                this.log.fatal((Object)MessageFormat.format("Getting latest model version from {0}, to check, if processed model version is new, failed", relevantFile.getFileId()), (Throwable)e);
            }
            catch (MorreException e) {
                this.log.warn((Object)"GraphDatabaseError while checking, if processed model version is new. It will be assumed, that this is unknown to the database!", (Throwable)e);
            }
            if (latest != null && latest.isAvailable()) {
                versionId = latest.getVersionId();
                versionDate = latest.getVersionDate();
            }
        }
        if (this.log.isInfoEnabled()) {
            if (versionId != null && versionDate != null) {
                this.log.info((Object)MessageFormat.format("Found latest version for {0} : {1}@{2}", relevantFile.getFileId(), versionId, versionDate));
            } else {
                this.log.info((Object)MessageFormat.format("Found no latest version for {0}. Must be the first occure", relevantFile.getFileId()));
            }
        }
        relevantFile.setLatestKnownVersion(versionId, versionDate, (PmrChangeSet)changeSet);
    }

    protected List<RevCommit> detectRelevantVersions(Git repo, List<RelevantFile> relevantFiles) {
        Date oldestLatestVersionDate = null;
        boolean foundOldestLatestVersionDate = false;
        Iterable relevantVersions = null;
        LinkedList<RevCommit> relevantVersionList = new LinkedList<RevCommit>();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"start detection of relevant git versions");
        }
        if (relevantFiles.size() == 0) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"List of relevantFiles is empty. So no version is relevant.");
            }
            return null;
        }
        LogCommand logCmd = repo.log();
        for (RelevantFile file : relevantFiles) {
            logCmd.addPath(file.getFilePath());
            if (oldestLatestVersionDate == null) {
                if (foundOldestLatestVersionDate) continue;
                oldestLatestVersionDate = file.getLatestVersionDate();
                foundOldestLatestVersionDate = true;
                continue;
            }
            if (file.getLatestVersionDate() == null || oldestLatestVersionDate.compareTo(file.getLatestVersionDate()) <= 0) continue;
            oldestLatestVersionDate = file.getLatestVersionDate();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)MessageFormat.format("execute Log command for {0} file(s)", relevantFiles.size()));
        }
        try {
            relevantVersions = logCmd.call();
        }
        catch (GitAPIException e) {
            this.log.error((Object)"Error while executing log command", (Throwable)e);
            return null;
        }
        int originalLength = 0;
        int newLength = 0;
        for (RevCommit commit : relevantVersions) {
            ++originalLength;
            if (oldestLatestVersionDate != null && new Date(commit.getCommitTime()).compareTo(oldestLatestVersionDate) <= 0) continue;
            ++newLength;
            relevantVersionList.add(commit);
        }
        Collections.sort(relevantVersionList, new Comparator<RevCommit>(){

            @Override
            public int compare(RevCommit o1, RevCommit o2) {
                return o1.getCommitTime() - o2.getCommitTime();
            }
        });
        if (this.log.isInfoEnabled()) {
            if (originalLength == newLength) {
                this.log.info((Object)MessageFormat.format("Found {0} commits. Cannot skip any of them,  because no one is indexed", originalLength));
            } else {
                this.log.info((Object)MessageFormat.format("Found {0} commits, removes all commits older than {1} (oldestLatestVersion) from the list. {2} commits left.", originalLength, oldestLatestVersionDate, newLength));
            }
        }
        return relevantVersionList;
    }

    protected void iterateRelevantVersions(Git repo, File location, List<RelevantFile> relevantFiles, List<RevCommit> relevantVersions) throws IOException {
        Date crawledDate = new Date();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("Going throw all relevant versions of {0}", location));
        }
        for (RevCommit currentCommit : relevantVersions) {
            String currentName = currentCommit.getName();
            Date currentVersionDate = new Date(currentCommit.getCommitTime());
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)MessageFormat.format("Update to {0} Message: {1}", currentName, currentCommit.getShortMessage()));
            }
            try {
                repo.checkout().setName(currentName).call();
            }
            catch (GitAPIException e) {
                this.log.error((Object)MessageFormat.format("Exception while updating {0} to {1}. skip this repo.", location, currentName), (Throwable)e);
                return;
            }
            ArrayList<String> changedFiles = new ArrayList<String>();
            Repository repository = repo.getRepository();
            RevWalk revWalk = new RevWalk(repository);
            ObjectId head = repository.resolve("HEAD");
            RevCommit commit = revWalk.parseCommit((AnyObjectId)head);
            RevCommit parent = null;
            if (commit.getParentCount() > 0) {
                parent = revWalk.parseCommit((AnyObjectId)commit.getParent(0).getId());
                DiffFormatter diffFormatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
                diffFormatter.setRepository(repository);
                diffFormatter.setDiffComparator(RawTextComparator.DEFAULT);
                diffFormatter.setDetectRenames(true);
                List diffs = diffFormatter.scan(parent.getTree(), commit.getTree());
                for (DiffEntry diff : diffs) {
                    changedFiles.add(diff.getNewPath());
                }
            } else {
                changedFiles = null;
            }
            if (this.log.isInfoEnabled()) {
                if (changedFiles != null) {
                    this.log.info((Object)MessageFormat.format("{0} changed files in this version", changedFiles.size()));
                } else {
                    this.log.info((Object)"This is the first commit. Assume every file has changed");
                }
            }
            for (RelevantFile file : relevantFiles) {
                File fileLocation;
                boolean hasChanges = false;
                String latestVersionId = null;
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)MessageFormat.format("Check model {0}", file.getFileId()));
                }
                if (!(fileLocation = new File(location, file.getFilePath())).exists()) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info((Object)"Model does not exists in this version -> skip it.");
                    continue;
                }
                if (file.getLatestVersionId() != null && file.getLatestVersionDate() != null) {
                    if (file.getLatestVersionId().equals(currentName) || file.getLatestVersionDate().compareTo(currentVersionDate) >= 0) {
                        if (!this.log.isInfoEnabled()) continue;
                        this.log.info((Object)"Current version is to old -> no changes.");
                        continue;
                    }
                    latestVersionId = file.getLatestVersionId();
                } else {
                    hasChanges = true;
                    latestVersionId = null;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Model has no parents -> this is a new version.");
                    }
                }
                if (!hasChanges) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"Check if model is in the changed files list");
                    }
                    if (changedFiles == null || changedFiles.contains(file.getFilePath())) {
                        hasChanges = true;
                        latestVersionId = null;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Model is in the changed files list.");
                        }
                    }
                }
                PmrChange change = null;
                try {
                    change = new PmrChange(file.getRepositoryUrl(), file.getFilePath(), currentName.toString(), currentVersionDate, crawledDate);
                }
                catch (URISyntaxException e) {
                    this.log.error((Object)"Error while creating Change Object. Abort processing current repo.", (Throwable)e);
                    return;
                }
                if (hasChanges) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"Model has changes. Adds it to its ChangeSet");
                    }
                    change.setMeta("source", "PMR2");
                    if ((file.getType() & 2) > 0) {
                        change.setModelType("SBML");
                    } else if ((file.getType() & 4) > 0) {
                        change.setModelType("CELLML");
                    }
                    try {
                        change.setXmlFile(fileLocation);
                        URI modelUri = this.modelStorage.storeModel(change);
                        change.setXmldoc(modelUri.toString());
                    }
                    catch (StorageException e) {
                        this.log.fatal((Object)"Error while storing model. Abort processing current repo.", (Throwable)e);
                        return;
                    }
                    file.addChange(change);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)(" repository URL " + change.getChangeRepositoryUrl(change)));
                    this.log.debug((Object)(" file path " + change.getChangeFilePath(change)));
                    this.log.debug((Object)(" file name " + change.getChangeFileName(change)));
                    this.log.debug((Object)(" version ID " + change.getChangeVersionId(change)));
                    this.log.debug((Object)(" version date " + change.getChangeVersionDate(change)));
                    this.log.debug((Object)(" crawled date " + change.getChangeCrawledDate(change)));
                    continue;
                }
                if (latestVersionId != null) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"Model has no changes. Link to parent version.");
                    }
                    try {
                        this.modelStorage.linkModelVersion(change.getFileId(), change.getVersionId(), latestVersionId);
                    }
                    catch (StorageException e) {
                        this.log.error((Object)"Error while linking to parent version.", (Throwable)e);
                    }
                    continue;
                }
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)"Model has no changes and no parent version. Nothing to link to");
            }
        }
    }

    protected class ExposureTransformJob
    implements Callable<URL> {
        private URL expLink = null;

        public ExposureTransformJob(URL expLink) {
            this.expLink = expLink;
        }

        @Override
        public URL call() throws Exception {
            return PmrDb.this.transformExposureUrl(this.expLink);
        }
    }

    private static class WorkingDirConfig {
        private Map<String, String> repositories = new HashMap<String, String>();

        public Map<String, String> getRepositories() {
            return this.repositories;
        }

        public void setRepositories(Map<String, String> repositories) {
            this.repositories = repositories;
        }
    }
}

