/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.databases.BioModelsDb;

import de.unirostock.sems.ModelCrawler.databases.Interface.Change;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BioModelsChange
extends Change {
    private static final long serialVersionUID = -8763419545605089673L;
    private final Log log = LogFactory.getLog(BioModelsChange.class);
    public static final String HASH_ALGORITHM = "SHA-256";
    public static final String HASH_ALGORITHM_FALLBACK = "SHA";
    public static final String META_HASH = "filehash";

    public BioModelsChange(URL repositoryUrl, String filePath, String versionId, Date versionDate, Date crawledDate) throws URISyntaxException {
        super(repositoryUrl, new String(FilenameUtils.getBaseName((String)filePath) + "." + FilenameUtils.getExtension((String)filePath)), versionId, versionDate, crawledDate);
    }

    public boolean setXmlFile(File xmlFile, String hash) {
        if (this.xmlFile == null && hash != null) {
            this.xmlFile = xmlFile;
            this.setMeta(META_HASH, hash);
            return true;
        }
        if (hash == null) {
            this.log.error((Object)"file hash is null!");
        } else {
            this.log.error((Object)"xmlFile is already setted!");
        }
        return false;
    }

    @Override
    public boolean setXmlFile(File xmlFile) {
        return this.setXmlFile(xmlFile, this.calcXmlHash(xmlFile));
    }

    public String getHash() {
        return this.getMeta(META_HASH);
    }

    protected String calcXmlHash(File xmlFile) {
        return this.calcXmlHash(xmlFile, HASH_ALGORITHM);
    }

    protected String calcXmlHash(File xmlFile, String algo) {
        String hash = null;
        try {
            FileInputStream stream = new FileInputStream(xmlFile);
            MessageDigest digest = MessageDigest.getInstance(algo);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = stream.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            stream.close();
            hash = new BigInteger(digest.digest()).toString(16);
        }
        catch (FileNotFoundException e) {
            xmlFile = null;
            hash = null;
            this.log.fatal((Object)"File not found to calc the hash!", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            if (algo.equals(HASH_ALGORITHM_FALLBACK)) {
                this.log.fatal((Object)"Even fallback hash algorithm does not work!", (Throwable)e);
                return null;
            }
            this.log.warn((Object)("Using fallback hash algorithm for " + xmlFile.getAbsolutePath()), (Throwable)e);
            this.calcXmlHash(xmlFile, HASH_ALGORITHM_FALLBACK);
        }
        catch (IOException e) {
            this.log.fatal((Object)("Can not read file for hash calc! " + xmlFile.getAbsolutePath()), (Throwable)e);
            return null;
        }
        return hash;
    }
}

