/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.databases.PMR2;

import de.unirostock.sems.ModelCrawler.databases.Interface.Change;
import de.unirostock.sems.ModelCrawler.databases.PMR2.PmrChange;
import de.unirostock.sems.ModelCrawler.databases.PMR2.PmrChangeSet;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;

public class RelevantFile {
    private String filePath;
    private URL repoUrl = null;
    private String fileId;
    private String latestKnownVersionId = null;
    private Date latestKnownVersionDate = null;
    private int type = 0;
    private PmrChangeSet changeSet = null;

    public RelevantFile(String filePath, String fileId) {
        this.filePath = filePath;
        this.fileId = fileId;
    }

    public RelevantFile(String filePath) {
        this.filePath = filePath;
    }

    public String generateFileId(String repoUrl) throws MalformedURLException, URISyntaxException {
        this.repoUrl = new URL(repoUrl);
        this.fileId = Change.generateFileId(this.repoUrl, this.filePath);
        return this.fileId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public URL getRepositoryUrl() {
        return this.repoUrl;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setLatestKnownVersion(String latestVersionId, Date latestVersionDate, PmrChangeSet changeSet) {
        this.latestKnownVersionId = latestVersionId;
        this.latestKnownVersionDate = latestVersionDate;
        this.changeSet = changeSet;
    }

    public void setLatestKnownVersion(String latestVersionId, Date latestVersionDate) {
        this.setLatestKnownVersion(latestVersionId, latestVersionDate, null);
    }

    public String getLatestKnownVersionId() {
        return this.latestKnownVersionId;
    }

    public Date getLatestKnownVersionDate() {
        return this.latestKnownVersionDate;
    }

    public String getLatestVersionId() {
        if (this.changeSet == null) {
            return this.latestKnownVersionId;
        }
        Change change = this.changeSet.getLatestChange();
        if (change != null) {
            return change.getVersionId();
        }
        return this.latestKnownVersionId;
    }

    public Date getLatestVersionDate() {
        if (this.changeSet == null) {
            return this.latestKnownVersionDate;
        }
        Change change = this.changeSet.getLatestChange();
        if (change != null) {
            return change.getVersionDate();
        }
        return this.latestKnownVersionDate;
    }

    public PmrChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void addChange(PmrChange change) {
        String parentVersionId;
        if (this.changeSet == null) {
            this.changeSet = new PmrChangeSet(this.fileId);
        }
        if ((parentVersionId = this.getLatestVersionId()) != null && !parentVersionId.isEmpty()) {
            change.addParent(this.getLatestVersionId());
        }
        this.changeSet.addChange(change);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

