/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.databases.BioModelsDb;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.unirostock.sems.ModelCrawler.Config;
import de.unirostock.sems.ModelCrawler.databases.BioModelsDb.BioModelRelease;
import de.unirostock.sems.ModelCrawler.databases.BioModelsDb.BioModelsChange;
import de.unirostock.sems.ModelCrawler.databases.BioModelsDb.BioModelsChangeSet;
import de.unirostock.sems.ModelCrawler.databases.BioModelsDb.exceptions.ExtractException;
import de.unirostock.sems.ModelCrawler.databases.BioModelsDb.exceptions.FtpConnectionException;
import de.unirostock.sems.ModelCrawler.databases.Interface.Change;
import de.unirostock.sems.ModelCrawler.databases.Interface.ChangeSet;
import de.unirostock.sems.ModelCrawler.databases.Interface.ModelDatabase;
import de.unirostock.sems.ModelCrawler.exceptions.StorageException;
import de.unirostock.sems.ModelCrawler.helper.CrawledModelRecord;
import de.unirostock.sems.morre.client.exception.MorreCommunicationException;
import de.unirostock.sems.morre.client.exception.MorreException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.dump.UnsupportedCompressionAlgorithmException;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class BioModelsDb
extends ModelDatabase {
    private static final long serialVersionUID = -1180005276710581809L;
    @JsonIgnore
    private final Log log = LogFactory.getLog(BioModelsDb.class);
    private URL ftpUrl = null;
    @JsonIgnore
    protected Map<String, ChangeSet> changeSetMap = new HashMap<String, ChangeSet>();
    @JsonIgnore
    private FTPClient ftpClient;
    @JsonIgnore
    protected WorkingDirConfig config = null;
    private File workingDir;

    @Override
    public List<String> listModels() {
        return new ArrayList<String>(this.changeSetMap.keySet());
    }

    @Override
    public Map<String, ChangeSet> listChanges() {
        return this.changeSetMap;
    }

    @Override
    public ChangeSet getModelChanges(String fileId) {
        return this.changeSetMap.get(fileId);
    }

    @Override
    public void close() {
        this.saveProperties();
        try {
            if (this.tempDir != null && this.tempDir.exists()) {
                FileUtils.deleteDirectory((File)this.tempDir);
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Error while cleaning up the temp dir!", (Throwable)e);
        }
    }

    @Override
    public Map<String, ChangeSet> call() {
        List<Object> newReleases = new ArrayList();
        if (this.ftpUrl == null) {
            this.log.error((Object)"Url for BMDB crawler not set!");
            throw new IllegalArgumentException("Url for BMDB crawler not set!");
        }
        if (this.morreClient == null && Config.getWorkingMode() != Config.WorkingMode.NO_MORRE) {
            this.log.error((Object)"No Morre crawler interface provided!");
            throw new IllegalArgumentException("No Morre crawler interface provided!");
        }
        if (!this.ftpUrl.getProtocol().toLowerCase().equals("ftp")) {
            this.log.error((Object)"Only ftp is supported at the moment for BioModelsDataBase!");
            throw new IllegalArgumentException("Only ftp is supported at the moment!");
        }
        this.log.info((Object)("Init new BioModels Database connector. URL: " + this.ftpUrl));
        this.ftpClient = new FTPClient();
        this.init();
        this.log.info((Object)"Start cloning the BioModels DataBase by fetching the releases!");
        try {
            this.connect();
            newReleases = this.retrieveReleaseList();
        }
        catch (IOException e) {
            this.log.fatal((Object)"IOException while connecting and getting the releases!", (Throwable)e);
        }
        catch (FtpConnectionException e) {
            this.log.fatal((Object)e);
        }
        if (this.config.getKnownReleases().size() > 0) {
            Iterator<Object> iter = newReleases.iterator();
            while (iter.hasNext()) {
                BioModelRelease bioModelRelease = (BioModelRelease)iter.next();
                if (!this.config.getKnownReleases().contains(bioModelRelease.getReleaseName())) continue;
                iter.remove();
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)MessageFormat.format("{0} new release(s)", newReleases.size()));
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info((Object)"every release is a new release...");
        }
        Collections.sort(newReleases);
        if (this.limit > 0) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)MessageFormat.format("Limit processed Releases to {0}", this.limit));
            }
            newReleases = newReleases.subList(0, this.limit);
        }
        for (BioModelRelease bioModelRelease : newReleases) {
            this.processRelease(bioModelRelease);
            if (!bioModelRelease.isDownloaded() || !bioModelRelease.isExtracted()) continue;
            this.config.getKnownReleases().add(bioModelRelease.getReleaseName());
        }
        this.log.info((Object)"finished cloning BioModelsDatabase!");
        return this.changeSetMap;
    }

    protected void processRelease(BioModelRelease release) {
        Date crawledDate = new Date();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("start processing release {0}", release.getReleaseName()));
        }
        try {
            if (!this.downloadRelease(release)) {
                this.log.fatal((Object)MessageFormat.format("Can not process release {0}", release.getReleaseName()));
                return;
            }
        }
        catch (UnsupportedCompressionAlgorithmException e) {
            this.log.fatal((Object)"Can not download-extract the release! Unsupported CompressionAlgorithm", (Throwable)e);
            return;
        }
        try {
            this.extractRelease(release);
        }
        catch (IllegalArgumentException e) {
            this.log.fatal((Object)"Something went wrong with the release Object! (IllegalArgumentException) ", (Throwable)e);
            return;
        }
        catch (ExtractException e) {
            this.log.fatal((Object)"Error while extracting", (Throwable)e);
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("start transfering changes from release {0} into change sets", release.getReleaseName()));
        }
        Iterator<String> iter = release.getModelList().iterator();
        while (iter.hasNext()) {
            this.tranferChange(iter.next(), release, crawledDate);
        }
        try {
            FileUtils.deleteDirectory((File)release.getContentDir());
        }
        catch (IOException e) {
            this.log.warn((Object)"Cannot clean up tmp dir for repository", (Throwable)e);
        }
    }

    protected void init() {
        this.workingDir = this.obtainWorkingDir();
        this.log.trace((Object)("Preparing working dir " + this.workingDir.getAbsolutePath()));
        if (!this.workingDir.exists()) {
            this.workingDir.mkdirs();
        }
        this.createTempDir();
        try {
            this.log.info((Object)"Loading working dir config");
            File configFile = new File(this.workingDir, Config.getConfig().getWorkingDirConfig());
            this.config = configFile.exists() ? (WorkingDirConfig)Config.getObjectMapper().readValue(configFile, WorkingDirConfig.class) : new WorkingDirConfig();
        }
        catch (IOException e) {
            this.log.fatal((Object)"Exception while reading the workingdir config file", (Throwable)e);
        }
    }

    protected void saveProperties() {
        if (this.config == null) {
            this.config = new WorkingDirConfig();
        }
        try {
            this.log.info((Object)"Saving working dir config");
            File configFile = new File(this.workingDir, Config.getConfig().getWorkingDirConfig());
            Config.getObjectMapper().writeValue(configFile, (Object)this.config);
            this.log.info((Object)"working dir config saved!");
        }
        catch (IOException e) {
            this.log.error((Object)"Can not write the workingDir config file!", (Throwable)e);
        }
    }

    protected void connect() throws FtpConnectionException, IOException, SocketException {
        this.log.info((Object)"connecting to ftp server");
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"establish socket connection");
            }
            this.ftpClient.connect(this.ftpUrl.getHost(), this.ftpUrl.getPort() == -1 ? 21 : this.ftpUrl.getPort());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"logging in");
            }
            if (!this.ftpClient.login("anonymous", "anonymous")) {
                throw new FtpConnectionException("Can not login with anonymous account!");
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"entering passiv mode");
            }
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setFileType(2);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"change directory to release directory");
            }
            if (!this.ftpClient.changeWorkingDirectory(this.ftpUrl.getPath())) {
                throw new FtpConnectionException("Can not change directory to release directory!");
            }
        }
        catch (SocketException e) {
            this.log.error((Object)"Can not connect to ftp server!", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.log.fatal((Object)"Can not connect to ftp server, IOException", (Throwable)e);
            throw e;
        }
    }

    protected void disconnect() {
        try {
            this.ftpClient.logout();
            this.ftpClient.disconnect();
        }
        catch (IOException e) {
            this.log.error((Object)"Error while disconnecting from ftp server, IOException", (Throwable)e);
        }
    }

    protected List<BioModelRelease> retrieveReleaseList() throws IOException {
        LinkedList<BioModelRelease> releaseList = new LinkedList<BioModelRelease>();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"retrieving release list form ftp server");
        }
        if (!this.ftpClient.isConnected()) {
            throw new IOException("Not connected to the server!");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        FTPFile[] dirs = this.ftpClient.listDirectories();
        for (int index = 0; index < dirs.length; ++index) {
            Date releaseTimeStamp;
            if (!dirs[index].isDirectory()) continue;
            try {
                releaseTimeStamp = dateFormat.parse(dirs[index].getName());
            }
            catch (ParseException e) {
                releaseTimeStamp = dirs[index].getTimestamp().getTime();
            }
            BioModelRelease release = new BioModelRelease(dirs[index].getName(), this.ftpUrl.getPath() + dirs[index].getName(), releaseTimeStamp);
            releaseList.add(release);
        }
        Collections.sort(releaseList);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("{0} releases on the server", releaseList.size()));
        }
        return releaseList;
    }

    private boolean downloadRelease(BioModelRelease release) throws UnsupportedCompressionAlgorithmException {
        byte[] buffer = new byte[4096];
        if (release == null) {
            return false;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("Start download release {0} from {1}", release.getReleaseName(), release.getFtpDirectory()));
        }
        if (release.isDownloaded() || release.isExtracted()) {
            this.log.warn((Object)"The release is already download and/or extracted!");
            return true;
        }
        try {
            Object uncompressedStream;
            String archiv;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"changes to release directory");
            }
            this.ftpClient.changeToParentDirectory();
            this.ftpClient.changeWorkingDirectory(release.getFtpDirectory());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to find the smbl only file");
            }
            if ((archiv = this.findSbmlArchivFile()) == null) {
                this.log.error((Object)"No matching file found!");
                return false;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)MessageFormat.format("found sbml file: {0}", archiv));
            }
            File target = new File(this.tempDir, "BioModelsDb_" + release.getReleaseName() + ".tar");
            BufferedOutputStream targetStream = new BufferedOutputStream(new FileOutputStream(target));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)MessageFormat.format("download and uncompress {0} to {1}", archiv, target.getAbsolutePath()));
            }
            InputStream downStream = this.ftpClient.retrieveFileStream(archiv);
            if (archiv.endsWith(".gz")) {
                uncompressedStream = new GzipCompressorInputStream(downStream);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"using gzip");
                }
            } else if (archiv.endsWith(".bzip") || archiv.endsWith(".bz") || archiv.endsWith(".bzip2") || archiv.endsWith(".bz2")) {
                uncompressedStream = new BZip2CompressorInputStream(downStream);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"using bzip");
                }
            } else if (archiv.endsWith(".tar")) {
                uncompressedStream = downStream;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"no compression, just a simple tar ball");
                }
            } else {
                targetStream.close();
                throw new UnsupportedCompressionAlgorithmException("Unknown file extension!");
            }
            int total = 0;
            int red = 0;
            while ((red = uncompressedStream.read(buffer)) != -1) {
                targetStream.write(buffer, 0, red);
                total += red;
            }
            targetStream.flush();
            targetStream.close();
            downStream.close();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)MessageFormat.format("download complete, {0} bytes", total));
            }
            if (!this.ftpClient.completePendingCommand()) {
                return false;
            }
            release.setArchivFile(target);
        }
        catch (UnsupportedCompressionAlgorithmException e) {
            this.log.error((Object)"Can not uncompress the release! Unsupported Compression Algo!", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            this.log.error((Object)"IOException while downloading and extracting the release!", (Throwable)e);
            return false;
        }
        return true;
    }

    private String findSbmlArchivFile() throws IOException {
        FTPFile[] files = this.ftpClient.listFiles();
        for (int index = 0; index < files.length; ++index) {
            if (!files[index].getName().contains("sbml_file")) continue;
            return files[index].getName();
        }
        return null;
    }

    private void extractRelease(BioModelRelease release) throws IllegalArgumentException, ExtractException {
        if (!release.isDownloaded() || release.isExtracted()) {
            throw new IllegalArgumentException("The release is suposed to be downloaded and not extracted!");
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("Start extracting release {0}", release.getReleaseName()));
        }
        HashMap<String, File> fileMap = new HashMap<String, File>();
        File contentDir = new File(this.tempDir, release.getReleaseName());
        contentDir.mkdirs();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Opening archive");
            }
            FileInputStream tarFileStream = new FileInputStream(release.getArchivFile());
            ArchiveInputStream archivStream = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)tarFileStream);
            ArchiveEntry entry = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"extract entries!");
            }
            while ((entry = archivStream.getNextEntry()) != null) {
                int extensionPos;
                File parentDir;
                File entryFile = new File(contentDir, entry.getName());
                if (entry.isDirectory()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)MessageFormat.format("Extract directory {0}", entryFile.getAbsolutePath()));
                    }
                    if (entryFile.exists() || entryFile.mkdirs()) continue;
                    throw new IllegalStateException("Can not create directory " + entryFile.getAbsolutePath());
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)MessageFormat.format("Extract file {0}", entryFile.getAbsolutePath()));
                }
                if (!(parentDir = entryFile.getAbsoluteFile().getParentFile()).exists()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)MessageFormat.format("Create directory {0} to store file {1}", parentDir, entryFile));
                    }
                    if (!parentDir.mkdirs()) {
                        throw new IllegalStateException("Can not create directory " + parentDir.getAbsolutePath());
                    }
                }
                FileOutputStream entryStream = new FileOutputStream(entryFile);
                IOUtils.copy((InputStream)archivStream, (OutputStream)entryStream);
                ((OutputStream)entryStream).close();
                String fileName = entryFile.getName();
                if (!fileName.substring((extensionPos = fileName.lastIndexOf(46)) + 1).toLowerCase().equals("xml")) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)MessageFormat.format("Found model {0} from file {1}", fileName, fileName));
                }
                fileMap.put(fileName, entryFile);
            }
            release.setContentDir(contentDir, fileMap);
        }
        catch (IllegalStateException e) {
            this.log.error((Object)e.getMessage());
            throw new ExtractException(e);
        }
        catch (ArchiveException e) {
            String message = MessageFormat.format("ArchiveException while extracting release {0}", release.getReleaseName());
            this.log.error((Object)message);
            throw new ExtractException(message, e);
        }
        catch (IOException e) {
            String message = MessageFormat.format("IOException while extracting release {0}", release.getReleaseName());
            this.log.error((Object)message);
            throw new ExtractException(message, e);
        }
    }

    private void tranferChange(String fileName, BioModelRelease release, Date crawledDate) {
        CrawledModelRecord latest;
        boolean isChangeNew = false;
        URL repositoryUrl = null;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)MessageFormat.format("Check if model {0} from release {1} is a new change", fileName, release.getReleaseName()));
        }
        BioModelsChangeSet changeSet = null;
        if (this.changeSetMap.containsKey(fileName)) {
            changeSet = (BioModelsChangeSet)this.changeSetMap.get(fileName);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"ChangeSet exists, fileId is not unknown!");
            }
        }
        BioModelsChange change = null;
        try {
            String filePath = this.ftpUrl.getFile();
            filePath = filePath.endsWith(String.valueOf(Config.getConfig().getPathSeparator())) ? filePath + fileName : filePath + String.valueOf(Config.getConfig().getPathSeparator()) + fileName;
            repositoryUrl = new URL(this.ftpUrl.getProtocol(), this.ftpUrl.getHost(), filePath);
            change = new BioModelsChange(repositoryUrl, filePath, release.getReleaseName(), release.getReleaseDate(), crawledDate);
            change.setMeta("source", "BMDB");
            change.setModelType("SBML");
            change.setXmlFile(release.getModelPath(fileName));
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)MessageFormat.format("calced file hash: {0}", change.getHash()));
            }
        }
        catch (MalformedURLException | URISyntaxException filePath) {
            // empty catch block
        }
        if (changeSet != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"compare hash with latest from changeSet");
            }
            if ((latest = (BioModelsChange)changeSet.getLatestChange()) != null && !change.getHash().equals(((BioModelsChange)latest).getHash()) && ((Change)latest).getVersionDate().compareTo(change.getVersionDate()) < 0) {
                isChangeNew = true;
                change.addParent(latest.getFileId(), latest.getVersionId());
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"hashs are not equal -> new version");
                }
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"ChangeSet does not exists, checking database");
            }
            changeSet = new BioModelsChangeSet(repositoryUrl, fileName);
            if (this.morreClient != null && Config.getWorkingMode() != Config.WorkingMode.NO_MORRE) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"start checking database");
                }
                latest = null;
                try {
                    latest = CrawledModelRecord.extendDataholder(this.morreClient.getLatestModelVersion(fileName));
                }
                catch (MorreCommunicationException e) {
                    this.log.fatal((Object)"Getting latest model version, to check, if processed model version is new, failed", (Throwable)e);
                }
                catch (MorreException e) {
                    this.log.warn((Object)"GraphDatabaseError while checking, if processed model version is new. It will be assumed, that this is unknown to the database!", (Throwable)e);
                    isChangeNew = true;
                }
                if (latest == null || !latest.isAvailable()) {
                    isChangeNew = true;
                } else {
                    String latestHash;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"successfully received latest from database");
                    }
                    if ((latestHash = latest.getMeta("filehash")) == null) {
                        this.log.error((Object)"There is no hash in the latest model. Maybe the database is inconsistent.");
                        isChangeNew = true;
                    } else if (!latestHash.equals(change.getHash()) && latest.getVersionDate().compareTo(change.getVersionDate()) < 0) {
                        isChangeNew = true;
                        change.addParent(latest.getFileId(), latest.getVersionId());
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)"hashs are not equal -> new version");
                        }
                    }
                }
            } else if (Config.getWorkingMode() == Config.WorkingMode.NO_MORRE) {
                isChangeNew = true;
            }
        }
        if (isChangeNew) {
            try {
                URI modelUri = this.modelStorage.storeModel(change);
                change.setXmldoc(modelUri.toString());
            }
            catch (StorageException e) {
                this.log.fatal((Object)"Error while storing model. Abort processing current change.", (Throwable)e);
                return;
            }
            changeSet.addChange(change);
            if (!this.changeSetMap.containsKey(fileName)) {
                this.changeSetMap.put(fileName, changeSet);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"put new version into change set");
            }
            if (this.log.isDebugEnabled()) {
                for (String element : this.changeSetMap.keySet()) {
                    this.log.debug((Object)"-------------------------------");
                    this.log.debug((Object)("  next element " + element));
                    this.log.debug((Object)"    has associated changeset:");
                    ChangeSet elementChangeSet = this.changeSetMap.get(element);
                    if (elementChangeSet.getChanges().size() == 0) {
                        this.log.debug((Object)"Empty :(");
                    }
                    for (Change c : elementChangeSet.getChanges()) {
                        this.log.debug((Object)("      repository URL " + c.getChangeRepositoryUrl(c)));
                        this.log.debug((Object)("      file path " + c.getChangeFilePath(c)));
                        this.log.debug((Object)("      file name " + c.getChangeFileName(c)));
                        this.log.debug((Object)("      version ID " + c.getChangeVersionId(c)));
                        this.log.debug((Object)("      version date " + c.getChangeVersionDate(c)));
                        this.log.debug((Object)("      crawled date " + c.getChangeCrawledDate(c)));
                        this.log.debug((Object)"-------------------------------");
                    }
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"not a new version of model");
        }
    }

    public URL getFtpUrl() {
        return this.ftpUrl;
    }

    public void setFtpUrl(URL ftpUrl) {
        this.ftpUrl = ftpUrl;
    }

    private static class WorkingDirConfig {
        private HashSet<String> knownReleases = new HashSet();

        private WorkingDirConfig() {
        }

        public HashSet<String> getKnownReleases() {
            return this.knownReleases;
        }

        public void setKnownReleases(HashSet<String> knownReleases) {
            this.knownReleases = knownReleases;
        }
    }
}

