/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.databases.Interface;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import de.unirostock.sems.ModelCrawler.Config;
import de.unirostock.sems.ModelCrawler.Constants;
import de.unirostock.sems.ModelCrawler.databases.BioModelsDb.BioModelsDb;
import de.unirostock.sems.ModelCrawler.databases.Interface.ChangeSet;
import de.unirostock.sems.ModelCrawler.databases.PMR2.PmrDb;
import de.unirostock.sems.ModelCrawler.storage.ModelStorage;
import de.unirostock.sems.morre.client.MorreCrawlerInterface;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ModelDatabase.class, name=""), @JsonSubTypes.Type(value=BioModelsDb.class, name="BMDB"), @JsonSubTypes.Type(value=PmrDb.class, name="PMR2")})
public abstract class ModelDatabase
implements Callable<Map<String, ChangeSet>>,
Closeable,
Serializable {
    private static final long serialVersionUID = -3406749011901702763L;
    @JsonIgnore
    private final Log log = LogFactory.getLog(ModelDatabase.class);
    protected boolean enabled = false;
    private String workingDirName = "wd-" + String.valueOf(Math.abs(new Random(new Date().getTime()).nextLong()));
    private File workingDir = null;
    protected int limit = 0;
    @JsonIgnore
    protected File tempDir = null;
    @JsonIgnore
    protected MorreCrawlerInterface morreClient = null;
    @JsonIgnore
    protected ModelStorage modelStorage = null;

    protected synchronized File createTempDir() {
        Config config = Config.getConfig();
        try {
            this.tempDir = Files.createTempDirectory(config.getTempDir().toPath(), config.getTempDirPrefix(), Constants.TEMP_DIR_POSIX_ATTRIBUTES).toFile();
            this.tempDir.deleteOnExit();
        }
        catch (Exception e) {
            this.tempDir = new File(config.getTempDir(), String.valueOf(new Random(new Date().getTime()).nextLong()));
            this.tempDir.mkdirs();
            this.tempDir.deleteOnExit();
            this.log.error((Object)("Cannot create TempDirectory, using '" + this.tempDir.getAbsolutePath() + "' instead."), (Throwable)e);
        }
        return this.tempDir;
    }

    @JsonIgnore
    public abstract List<String> listModels();

    @JsonIgnore
    public abstract Map<String, ChangeSet> listChanges();

    @JsonIgnore
    public abstract ChangeSet getModelChanges(String var1);

    @Override
    @JsonIgnore
    public abstract void close();

    @Override
    @JsonIgnore
    public abstract Map<String, ChangeSet> call();

    public String getWorkingDir() {
        return this.workingDirName;
    }

    protected synchronized File obtainWorkingDir() {
        if (this.workingDir == null) {
            this.workingDir = new File(Config.getConfig().getWorkingDir(), this.workingDirName);
        }
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDirName = workingDir;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonIgnore
    public MorreCrawlerInterface getMorreClient() {
        return this.morreClient;
    }

    @JsonIgnore
    public void setMorreClient(MorreCrawlerInterface morreClient) {
        this.morreClient = morreClient;
    }

    @JsonIgnore
    public ModelStorage getModelStorage() {
        return this.modelStorage;
    }

    @JsonIgnore
    public void setModelStorage(ModelStorage modelStorage) {
        this.modelStorage = modelStorage;
    }

    public abstract class DatabaseTypes {
        public static final String NONE = "";
        public static final String BMDB = "BMDB";
        public static final String PMR2 = "PMR2";
    }
}

