/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.storage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.unirostock.sems.ModelCrawler.Config;
import de.unirostock.sems.ModelCrawler.exceptions.StorageException;
import de.unirostock.sems.ModelCrawler.storage.FileBasedStorage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;

public class FtpStorage
extends FileBasedStorage {
    @JsonIgnore
    private static final long serialVersionUID = 1221888596087293844L;
    @JsonIgnore
    private final Log log = LogFactory.getLog(FtpStorage.class);
    private URL ftpUrl = null;
    private String ftpUser = null;
    private String ftpPass = null;
    @JsonIgnore
    private FTPClient ftpClient = null;

    @Override
    public void initConnection() throws StorageException {
        if (this.ftpClient != null) {
            throw new IllegalStateException("Storage is already connected");
        }
        if (this.ftpUrl == null) {
            throw new IllegalArgumentException("FTP URL is not allowed to be null");
        }
        if (this.httpAccessPath == null) {
            throw new IllegalArgumentException("HTTP Access Path is not allowed to be null");
        }
        try {
            this.ftpClient = new FTPClient();
            this.ftpClient.connect(this.ftpUrl.getHost(), this.ftpUrl.getPort() == -1 ? 21 : this.ftpUrl.getPort());
            if (this.ftpUser != null && !this.ftpUser.isEmpty() && this.ftpPass != null && !this.ftpPass.isEmpty()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"Login using provided FTP credentials");
                }
                if (!this.ftpClient.login(this.ftpUser, this.ftpPass)) {
                    throw new StorageException("Cannot login using provided FTP credentials");
                }
            } else {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"No ftp login credentials provided. Try anonymous login");
                }
                if (!this.ftpClient.login("anonymous", "anonymous")) {
                    throw new StorageException("Cannot login with anonymous account!");
                }
            }
            this.ftpClient.setFileType(2);
            this.ftpClient.enterLocalPassiveMode();
            if (!this.ftpClient.changeWorkingDirectory(this.ftpUrl.getPath())) {
                throw new StorageException(MessageFormat.format("Cannot change FTP working directory to {0}", this.ftpUrl.getPath()));
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Cannot connect to FTP server!", (Throwable)e);
            throw new StorageException("Cannot connect to FTP server", e);
        }
    }

    @Override
    public void closeConnection() {
        try {
            if (this.ftpClient != null) {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
                this.ftpClient = null;
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Cannot close FTP Connection", (Throwable)e);
        }
    }

    @Override
    protected void makeDirs(String path) throws StorageException {
        String pathSeparator = Config.getConfig().getPathSeparatorString();
        try {
            if (!this.ftpClient.changeWorkingDirectory("/")) {
                throw new StorageException("Cannot change to FTP base directory");
            }
            if (!path.startsWith(pathSeparator)) {
                path = pathSeparator + path;
            }
            this.ftpClient.makeDirectory(path);
        }
        catch (IOException e) {
            throw new StorageException("Cannot create new ftp dir: " + path, e);
        }
    }

    @Override
    protected void storeFile(InputStream source, String path) {
    }

    @Override
    protected InputStream getFile(String path) {
        return null;
    }

    @Override
    protected void linkFiles(String sourcePath, String targetPath) throws StorageException {
    }

    public URL getFtpUrl() {
        return this.ftpUrl;
    }

    public void setFtpUrl(URL ftpUrl) {
        this.ftpUrl = ftpUrl;
    }

    public String getFtpUser() {
        return this.ftpUser;
    }

    public void setFtpUser(String ftpUser) {
        this.ftpUser = ftpUser;
    }

    public String getFtpPass() {
        return this.ftpPass;
    }

    public void setFtpPass(String ftpPass) {
        this.ftpPass = ftpPass;
    }

    @Override
    protected void storeFile(InputStream source, String path, boolean override) throws StorageException {
    }
}

