/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.databases.BioModelsDb;

import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class BioModelRelease
implements Comparable<BioModelRelease> {
    private String releaseName;
    private String ftpDirectory;
    private Date releaseDate;
    private File archivFile = null;
    private File contentDir = null;
    private Map<String, File> modelMap;

    public BioModelRelease(String releaseName, String ftpDirectory, Date releaseDate, File archivFile) {
        this.releaseName = releaseName;
        this.ftpDirectory = ftpDirectory;
        this.releaseDate = releaseDate;
        this.archivFile = archivFile;
    }

    public BioModelRelease(String releaseName, String ftpDirectory, Date releaseDate) {
        this.releaseName = releaseName;
        this.ftpDirectory = ftpDirectory;
        this.releaseDate = releaseDate;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public File getArchivFile() {
        return this.archivFile;
    }

    public boolean setArchivFile(File archivFile) {
        if (this.archivFile == null) {
            this.archivFile = archivFile;
            return true;
        }
        return false;
    }

    public Set<String> getModelList() {
        return this.modelMap.keySet();
    }

    public File getModelPath(String fileId) {
        return this.modelMap.get(fileId);
    }

    public String getFtpDirectory() {
        return this.ftpDirectory;
    }

    public File getContentDir() {
        return this.contentDir;
    }

    public boolean setContentDir(File contentDir, Map<String, File> modelMap) {
        if (this.contentDir == null && this.modelMap == null) {
            this.modelMap = modelMap;
            this.contentDir = contentDir;
            return true;
        }
        return false;
    }

    public boolean isDownloaded() {
        return this.archivFile != null;
    }

    public boolean isExtracted() {
        return this.contentDir != null;
    }

    @Override
    public int compareTo(BioModelRelease model) {
        return this.releaseDate.compareTo(model.getReleaseDate());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.releaseDate == null ? 0 : this.releaseDate.hashCode());
        result = 31 * result + (this.releaseName == null ? 0 : this.releaseName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BioModelRelease other = (BioModelRelease)obj;
        if (this.releaseDate == null ? other.releaseDate != null : !this.releaseDate.equals(other.releaseDate)) {
            return false;
        }
        return !(this.releaseName == null ? other.releaseName != null : !this.releaseName.equals(other.releaseName));
    }

    public String toString() {
        return "BioModelRelease [" + this.releaseName + "]";
    }
}

