/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.storage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.unirostock.sems.ModelCrawler.exceptions.StorageException;
import de.unirostock.sems.ModelCrawler.storage.FileBasedStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileStorage
extends FileBasedStorage {
    @JsonIgnore
    private static final long serialVersionUID = 139783500897489458L;
    @JsonIgnore
    private static final Log log = LogFactory.getLog(FileBasedStorage.class);
    private File baseDir = null;

    @Override
    protected void initConnection() throws StorageException {
        if (this.baseDir == null) {
            throw new StorageException("No base Directory was set");
        }
        if (!(this.baseDir.exists() && this.baseDir.isDirectory() || this.baseDir.mkdirs())) {
            throw new StorageException("Cannot create base directory.");
        }
        if (!this.baseDir.canRead() || !this.baseDir.canWrite()) {
            throw new StorageException("Cannot read or write in base directory");
        }
    }

    @Override
    protected void closeConnection() {
    }

    @Override
    protected void makeDirs(String path) throws StorageException {
        File newDirectory = new File(this.baseDir, path);
        if (!newDirectory.exists() && !newDirectory.mkdirs()) {
            throw new StorageException("Cannot create directory: " + newDirectory.toString());
        }
    }

    @Override
    protected void storeFile(InputStream source, String path) throws StorageException {
        this.storeFile(source, path, false);
    }

    @Override
    protected void storeFile(InputStream source, String path, boolean override) throws StorageException {
        File file = new File(this.baseDir, path);
        try {
            if (Files.isSymbolicLink(file.toPath())) {
                file.delete();
            } else if (file.exists()) {
                if (!override) {
                    throw new StorageException(MessageFormat.format("File exists already. Cannot override {0}", file));
                }
                file.delete();
            }
            FileOutputStream output = new FileOutputStream(file);
            IOUtils.copy((InputStream)source, (OutputStream)output);
            output.flush();
            ((OutputStream)output).close();
            source.close();
        }
        catch (FileNotFoundException e) {
            throw new StorageException("Cannot create file", e);
        }
        catch (IOException e) {
            throw new StorageException("Exception while storing file to disk", e);
        }
    }

    @Override
    protected InputStream getFile(String path) throws StorageException {
        File file = new File(this.baseDir, path);
        if (!file.exists()) {
            throw new StorageException("Cannot find file: " + file.toString());
        }
        if (!file.canRead() || !file.isFile()) {
            throw new StorageException("Cannot access file: " + file.toString());
        }
        try {
            FileInputStream stream = new FileInputStream(file);
            return stream;
        }
        catch (FileNotFoundException e) {
            throw new StorageException("Cannot open file: " + file, e);
        }
    }

    @Override
    protected void linkFiles(String sourcePath, String targetPath) throws StorageException {
        File sourceFile = new File(this.baseDir, sourcePath);
        File targetFile = new File(this.baseDir, targetPath);
        if (!targetFile.exists()) {
            throw new StorageException("Cannot create link to a non-existing file: " + targetFile);
        }
        try {
            try {
                Files.createSymbolicLink(sourceFile.toPath(), targetFile.toPath(), new FileAttribute[0]);
            }
            catch (UnsupportedOperationException e1) {
                log.warn((Object)MessageFormat.format("File system cannot handle symlink from {0} to {1}. Try hard link instead.", sourceFile, targetFile), (Throwable)e1);
                Files.createLink(sourceFile.toPath(), targetFile.toPath());
            }
        }
        catch (IOException e) {
            log.error((Object)MessageFormat.format("Cannot create link from {0} to {1}.", sourceFile, targetFile), (Throwable)e);
            throw new StorageException(MessageFormat.format("Cannot create link from {0} to {1}.", sourceFile, targetFile), e);
        }
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }
}

