/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.storage;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import de.unirostock.sems.ModelCrawler.databases.Interface.Change;
import de.unirostock.sems.ModelCrawler.databases.Interface.ChangeSet;
import de.unirostock.sems.ModelCrawler.exceptions.StorageException;
import de.unirostock.sems.ModelCrawler.storage.FileStorage;
import de.unirostock.sems.ModelCrawler.storage.FtpStorage;
import java.io.Closeable;
import java.io.Serializable;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=FileStorage.class, name="file"), @JsonSubTypes.Type(value=FtpStorage.class, name="ftp")})
public abstract class ModelStorage
implements Serializable,
Closeable {
    private static final long serialVersionUID = -1028829011896100407L;

    public abstract void connect() throws StorageException;

    @Override
    public abstract void close();

    public abstract URI storeModel(Change var1) throws StorageException;

    public abstract URI linkModelVersion(String var1, String var2, String var3) throws StorageException;

    public List<URI> storeModelChangeSet(ChangeSet changeSet) throws StorageException {
        LinkedList<URI> result = new LinkedList<URI>();
        for (Change model : changeSet.getChanges()) {
            result.add(this.storeModel(model));
        }
        return result;
    }

    public static abstract class Types {
        public static final String FILE = "file";
        public static final String FTP = "ftp";
    }
}

