/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler;

import de.unirostock.sems.ModelCrawler.Config;
import de.unirostock.sems.ModelCrawler.databases.BioModelsDb.BioModelsDb;
import de.unirostock.sems.ModelCrawler.databases.Interface.Change;
import de.unirostock.sems.ModelCrawler.databases.Interface.ChangeSet;
import de.unirostock.sems.ModelCrawler.databases.Interface.ModelDatabase;
import de.unirostock.sems.ModelCrawler.databases.PMR2.PmrDb;
import de.unirostock.sems.ModelCrawler.exceptions.ConfigurationException;
import de.unirostock.sems.ModelCrawler.exceptions.StorageException;
import de.unirostock.sems.ModelCrawler.storage.FileStorage;
import de.unirostock.sems.ModelCrawler.storage.ModelStorage;
import de.unirostock.sems.morre.client.MorreCrawlerInterface;
import de.unirostock.sems.morre.client.dataholder.CrawledModel;
import de.unirostock.sems.morre.client.exception.MorreException;
import de.unirostock.sems.morre.client.impl.HttpMorreClient;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class App {
    private static App instance = null;
    private static final Log log = LogFactory.getLog(App.class);
    private static MorreCrawlerInterface morreClient;
    private static ModelStorage storage;
    private static Map<String, ChangeSet> changes;
    private static Map<String, ChangeSet> changesPerRelease;

    public static void main(String[] args) {
        App.getApp(args);
    }

    public static App getApp(String[] args) {
        if (instance == null) {
            instance = new App(args);
        }
        return instance;
    }

    private App(String[] args) {
        Config config;
        File configFile = App.configureCrawler(args);
        log.info((Object)"ModelCrawler started");
        if (Config.getWorkingMode() == Config.WorkingMode.TEMPLATE_CONFIG) {
            if (configFile == null) {
                log.error((Object)"No config file provided, use -c flag");
                System.exit(0);
            }
            log.info((Object)MessageFormat.format("Writing default config to {0}", configFile));
            config = Config.defaultConfig();
            config.getDatabases().add(new BioModelsDb());
            config.getDatabases().add(new PmrDb());
            config.setStorage(new FileStorage());
            try {
                Config.getConfig().save(configFile);
            }
            catch (ConfigurationException e) {
                log.fatal((Object)MessageFormat.format("Can not save config file {0}", configFile), (Throwable)e);
            }
            log.info((Object)"done.");
            System.exit(0);
        }
        try {
            if (configFile != null) {
                Config.load(configFile);
            }
        }
        catch (ConfigurationException e) {
            log.fatal((Object)MessageFormat.format("Can not load config file {0}", configFile), (Throwable)e);
        }
        config = Config.getConfig();
        App.initConnectors(config);
        changes = new HashMap<String, ChangeSet>();
        for (ModelDatabase database : config.getDatabases()) {
            if (!database.isEnabled()) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)MessageFormat.format("running crawler for {0}", database.getClass().getName()));
            }
            changesPerRelease = database.call();
            changes.putAll(database.listChanges());
            if (!log.isInfoEnabled()) continue;
            log.info((Object)MessageFormat.format("finished crawling for {0}", database.getClass().getName()));
        }
        int changeSetCount = 0;
        int modelCount = 0;
        if (Config.getWorkingMode() == Config.WorkingMode.TEST) {
            log.info((Object)"Do not push ChangeSets to morre or store them in test-mode");
        } else if (Config.getWorkingMode() == Config.WorkingMode.NO_MORRE) {
            log.info((Object)"Do not push ChangeSets to morre in NO_MORRE mode.");
        } else {
            Iterator<ChangeSet> changesSetIterator = changes.values().iterator();
            while (changesSetIterator.hasNext()) {
                int count = App.processChangeSet(changesSetIterator.next());
                ++changeSetCount;
                modelCount += count;
            }
            storage.close();
        }
        App.close();
        log.info((Object)"finished crawling");
        log.info((Object)MessageFormat.format("pushed {0} changesets with {1} models, {2,number,##.#} models per changeset", changeSetCount, modelCount, changeSetCount > 0 ? (double)(modelCount / changeSetCount) : 0.0));
    }

    private static File configureCrawler(String[] args) {
        File configFile = null;
        if (args.length == 0) {
            App.printHelp();
            System.exit(0);
        }
        for (int index = 0; index < args.length; ++index) {
            if (args[index].equals("-c") || args[index].equals("--config")) {
                configFile = new File(args[++index]);
                continue;
            }
            if (args[index].equals("--template")) {
                Config.setWorkingMode(Config.WorkingMode.TEMPLATE_CONFIG);
                continue;
            }
            if (args[index].equals("--test")) {
                Config.setWorkingMode(Config.WorkingMode.TEST);
                continue;
            }
            if (!args[index].equals("--no-morre")) continue;
            Config.setWorkingMode(Config.WorkingMode.NO_MORRE);
        }
        return configFile;
    }

    private static void printHelp() {
        System.out.println("ModelCrawler");
        System.out.println("  -c               Path to config\n  --config \n  --template       Writes down a template config file (overrides existing config!) \n  --test           Test mode. Nothing is pushed to morre nor stored persistent \n  --no-morre       Do not utilize morre to determine the latest known version nor \n                   stores any model in the database. Just download and store models. \n                   May cause doubles, when used for BioModels");
    }

    private static void initConnectors(Config config) {
        log.info((Object)"Prepare storage connector");
        storage = config.getStorage();
        try {
            storage.connect();
        }
        catch (StorageException e) {
            log.fatal((Object)"Exception while connecting to storage", (Throwable)e);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Start GraphDb/MORRE connector");
        }
        try {
            if (Config.getWorkingMode() != Config.WorkingMode.NO_MORRE) {
                morreClient = new HttpMorreClient(config.getMorreUrl());
            }
        }
        catch (MalformedURLException e) {
            log.fatal((Object)"Malformed Url for MORRE in config file", (Throwable)e);
        }
        for (ModelDatabase connector : config.getDatabases()) {
            connector.setMorreClient(morreClient);
            connector.setModelStorage(storage);
        }
    }

    private static void close() {
        log.info((Object)"Cleans everything up!");
        for (ModelDatabase database : Config.getConfig().getDatabases()) {
            if (!database.isEnabled()) continue;
            database.close();
        }
    }

    private static int processChangeSet(ChangeSet changeSet) {
        if (log.isInfoEnabled()) {
            log.info((Object)MessageFormat.format("Start processing ChangeSet for model {0} with {1} entrie(s)", changeSet.getFileId(), changeSet.getChanges().size()));
        }
        int modelCount = 0;
        Iterator<Change> changeIterator = changeSet.getChanges().iterator();
        Change change = null;
        try {
            while (changeIterator.hasNext()) {
                String modelUri;
                change = changeIterator.next();
                if (log.isInfoEnabled()) {
                    log.info((Object)MessageFormat.format("pushes model {0}:{1}", change.getFileId(), change.getVersionId()));
                }
                if ((modelUri = change.getXmldoc()) == null) {
                    modelUri = storage.storeModel(change).toString();
                }
                change.setXmldoc(modelUri);
                morreClient.addModel((CrawledModel)change);
                ++modelCount;
            }
        }
        catch (IOException e) {
            log.fatal((Object)MessageFormat.format("Some IO stuff went wrong while pushing model {0} !", change), (Throwable)e);
        }
        catch (MorreException e) {
            log.error((Object)MessageFormat.format("Morre encountered an error while puschin model {0} : {1}", change, e.getMessage()), (Throwable)e);
        }
        catch (StorageException e) {
            log.fatal((Object)MessageFormat.format("Something went wrong while pushing model {0} !", change), (Throwable)e);
        }
        return modelCount;
    }

    public Map<String, ChangeSet> getChanges() {
        return changes;
    }

    public Map<String, ChangeSet> getChangesPerRelease() {
        return changesPerRelease;
    }

    static {
        storage = null;
        changes = null;
        changesPerRelease = null;
    }
}

