/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler;

import de.unirostock.sems.ModelCrawler.App;
import de.unirostock.sems.ModelCrawler.databases.Interface.Change;
import de.unirostock.sems.ModelCrawler.databases.Interface.ChangeSet;
import java.util.ArrayList;
import java.util.Map;

public class CrawlerAPI {
    public static final String REPOSITORY_URL = new String("repositoryUrl");
    public static final String FILE_PATH = new String("filePath");
    public static final String FILE_NAME = new String("fileName");
    public static final String VERSION_ID = new String("versionId");
    public static final String VERSION_DATE = new String("versionDate");
    public static final String CRAWLED_DATE = new String("crawledDate");
    private App crawler = null;

    public CrawlerAPI(String[] args) {
        this.crawler = App.getApp(args);
    }

    public static ArrayList<String> getDownloadedModels(App crawler) {
        ArrayList<String> models = new ArrayList<String>();
        for (Map.Entry<String, ChangeSet> entry : crawler.getChanges().entrySet()) {
            models.add(entry.getKey());
        }
        return models;
    }

    public static Map<String, ChangeSet> getChangesPerRelease(CrawlerAPI api) {
        return api.crawler.getChangesPerRelease();
    }

    private static void printDownloadedModels(ArrayList<String> models) {
        for (String model : models) {
            System.err.println("  Retrieved model " + model);
        }
    }

    private static void printChangesPerRelease(Map<String, ChangeSet> changesPerRelease) {
        for (String element : changesPerRelease.keySet()) {
            System.err.println("-------------------------------");
            System.err.println("  next element " + element);
            System.err.println("    has associated changeset:");
            ChangeSet elementChangeSet = changesPerRelease.get(element);
            for (Change c : elementChangeSet.getChanges()) {
                System.err.println("      repository URL " + c.getChangeRepositoryUrl(c));
                System.err.println("      file path " + c.getChangeFilePath(c));
                System.err.println("      file name " + c.getChangeFileName(c));
                System.err.println("      version ID " + c.getChangeVersionId(c));
                System.err.println("      version date " + c.getChangeVersionDate(c));
                System.err.println("      crawled date " + c.getChangeCrawledDate(c));
                System.err.println("-------------------------------");
            }
        }
    }

    private static String getChange(Change change, String field) {
        String result = null;
        if (field.equals(REPOSITORY_URL)) {
            result = change.getChangeRepositoryUrl(change);
        } else if (field.equals(FILE_PATH)) {
            result = change.getChangeFilePath(change);
        } else if (field.equals(FILE_NAME)) {
            result = change.getChangeFileName(change);
        } else if (field.equals(VERSION_ID)) {
            result = change.getChangeVersionId(change);
        } else if (field.equals(VERSION_DATE)) {
            result = change.getChangeVersionDate(change);
        } else if (field.equals(CRAWLED_DATE)) {
            result = change.getChangeCrawledDate(change);
        }
        return result;
    }

    public static ChangeSet getModelChangeSet(Map<String, ChangeSet> changesPerRelease, String modelName) {
        return changesPerRelease.get(modelName);
    }

    public static String getModelChange(Change change, String field) {
        return CrawlerAPI.getChange(change, field);
    }

    public static void main(String[] args) {
        CrawlerAPI crawlerAPI = new CrawlerAPI(args);
        Map<String, ChangeSet> changesPerRelease = CrawlerAPI.getChangesPerRelease(crawlerAPI);
        String targetModelName = new String("BIOMD0000000057.xml");
        System.err.println("Retrieve model " + targetModelName + "'s change set:");
        ChangeSet modelChangeSet = CrawlerAPI.getModelChangeSet(changesPerRelease, targetModelName);
        System.err.println("  Model " + targetModelName + " has change set object " + modelChangeSet.toString() + " containing:");
        for (Change modelChange : modelChangeSet.getChanges()) {
            System.err.println("    Change with associated metadata:");
            System.err.println("      repository URL " + CrawlerAPI.getModelChange(modelChange, REPOSITORY_URL));
            System.err.println("      file path " + CrawlerAPI.getModelChange(modelChange, FILE_PATH));
            System.err.println("      file name " + CrawlerAPI.getModelChange(modelChange, FILE_NAME));
            System.err.println("      version ID " + CrawlerAPI.getModelChange(modelChange, VERSION_ID));
            System.err.println("      version date " + CrawlerAPI.getModelChange(modelChange, VERSION_DATE));
            System.err.println("      crawled date " + CrawlerAPI.getModelChange(modelChange, CRAWLED_DATE));
        }
    }
}

