/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.storage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.unirostock.sems.ModelCrawler.Config;
import de.unirostock.sems.ModelCrawler.databases.Interface.Change;
import de.unirostock.sems.ModelCrawler.exceptions.StorageException;
import de.unirostock.sems.ModelCrawler.storage.ModelStorage;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FileBasedStorage
extends ModelStorage {
    @JsonIgnore
    private static final long serialVersionUID = 5628650761119478142L;
    @JsonIgnore
    private final Log log = LogFactory.getLog(FileBasedStorage.class);
    protected URL httpAccessPath = null;
    @JsonIgnore
    protected Config config = null;

    protected abstract void initConnection() throws StorageException;

    protected abstract void closeConnection();

    protected abstract void makeDirs(String var1) throws StorageException;

    protected abstract void storeFile(InputStream var1, String var2) throws StorageException;

    protected abstract void storeFile(InputStream var1, String var2, boolean var3) throws StorageException;

    protected abstract InputStream getFile(String var1) throws StorageException;

    protected abstract void linkFiles(String var1, String var2) throws StorageException;

    @Override
    public void connect() throws StorageException {
        this.config = Config.getConfig();
        this.initConnection();
    }

    @Override
    public void close() {
        this.closeConnection();
    }

    @Override
    public URI storeModel(Change modelChange) throws StorageException {
        if (Config.getWorkingMode() == Config.WorkingMode.TEST) {
            this.log.info((Object)MessageFormat.format("Test model. Skip storage of {0}", modelChange));
            return null;
        }
        String[] fileId = this.splitFileId(modelChange.getFileId());
        String outerPath = fileId[0];
        String innerPath = fileId[1];
        String fileName = fileId[2];
        try {
            this.makeDirs(outerPath);
            VersionInfo info = this.getVersionInfo(outerPath);
            String pathToFile = outerPath + modelChange.getVersionId() + this.config.getPathSeparatorString() + innerPath;
            this.makeDirs(pathToFile);
            if (info == null) {
                info = new VersionInfo();
            }
            VersionInfo.FileVersionInfo versionInfo = null;
            versionInfo = info.addModel(modelChange.getFileId());
            versionInfo.addVersion(modelChange.getVersionDate(), modelChange.getVersionId());
            FileInputStream input = new FileInputStream(modelChange.getXmlFile());
            this.storeFile(input, pathToFile + fileName);
            ((InputStream)input).close();
            this.writeVersionInfo(outerPath, info);
            String accessPath = this.httpAccessPath.getPath();
            if (!accessPath.endsWith(this.config.getPathSeparatorString())) {
                accessPath = accessPath + this.config.getPathSeparatorString();
            }
            accessPath = accessPath + pathToFile + fileName;
            URI uri = new URI(this.httpAccessPath.getProtocol(), null, this.httpAccessPath.getHost(), this.httpAccessPath.getPort(), accessPath, null, null);
            return uri;
        }
        catch (StorageException e) {
            this.log.error((Object)"Exception while accessing storage layer", (Throwable)e);
            throw e;
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"Cannot find xml document.", (Throwable)e);
            throw new StorageException("Cannot find xml document", e);
        }
        catch (IOException e) {
            this.log.error((Object)"Cannot store xml document.", (Throwable)e);
            throw new StorageException("Cannot store xml document.", e);
        }
        catch (URISyntaxException e) {
            this.log.error((Object)"Exception while building access URI", (Throwable)e);
            throw new StorageException("Exception while building access URI", e);
        }
    }

    @Override
    public URI linkModelVersion(String fileId, String sourceVersionId, String targetVersionId) throws StorageException {
        if (Config.getWorkingMode() == Config.WorkingMode.TEST) {
            this.log.info((Object)MessageFormat.format("Test model. Skip linking {2}, {0} to {1}", sourceVersionId, targetVersionId, fileId));
            return null;
        }
        if (fileId == null || fileId.isEmpty()) {
            throw new StorageException("FileId should not be null");
        }
        if (sourceVersionId == null || sourceVersionId.isEmpty() || targetVersionId == null | targetVersionId.isEmpty()) {
            throw new StorageException("VersionId should not be null");
        }
        if (sourceVersionId.equals(targetVersionId)) {
            throw new StorageException("target and source versionId are not allowed to be equal");
        }
        String[] splittedFileId = this.splitFileId(fileId);
        String pathToSource = splittedFileId[0] + sourceVersionId + this.config.getPathSeparatorString() + splittedFileId[1];
        String sourcePath = pathToSource + splittedFileId[2];
        String targetPath = splittedFileId[0] + targetVersionId + this.config.getPathSeparatorString() + splittedFileId[1] + splittedFileId[2];
        try {
            this.makeDirs(pathToSource);
            this.linkFiles(sourcePath, targetPath);
            String accessPath = this.httpAccessPath.getPath();
            if (!accessPath.endsWith(this.config.getPathSeparatorString())) {
                accessPath = accessPath + this.config.getPathSeparatorString();
            }
            accessPath = accessPath + sourcePath;
            URI uri = new URI(this.httpAccessPath.getProtocol(), this.httpAccessPath.getHost(), accessPath, null);
            return uri;
        }
        catch (StorageException e) {
            this.log.error((Object)"Exception while accessing storage layer", (Throwable)e);
            throw e;
        }
        catch (URISyntaxException e) {
            this.log.error((Object)"Exception while building access URI", (Throwable)e);
            throw new StorageException("Exception while building access URI", e);
        }
    }

    private String[] splitFileId(String fileId) {
        boolean OUTER_PATH = false;
        boolean INNER_PATH = true;
        int FILENAME = 2;
        String[] result = new String[3];
        String[] splittedFileId = fileId.split(":");
        StringBuilder path = new StringBuilder();
        for (int index = 2; index < splittedFileId.length; ++index) {
            if (splittedFileId[index] == null || splittedFileId[index].isEmpty()) continue;
            if (splittedFileId[index].equals("!") && result[0] == null) {
                result[0] = path.toString();
                path = new StringBuilder();
                continue;
            }
            if (index == splittedFileId.length - 1 && result[0] != null && result[1] == null) {
                result[1] = path.toString();
                result[2] = splittedFileId[index];
                continue;
            }
            path.append(splittedFileId[index]);
            path.append(this.config.getPathSeparator());
        }
        return result;
    }

    private VersionInfo getVersionInfo(String outerPath) throws StorageException {
        VersionInfo info = null;
        if (outerPath == null || outerPath.isEmpty()) {
            throw new IllegalArgumentException("outerPath is not allowed to be empty");
        }
        if (!outerPath.endsWith(String.valueOf(this.config.getPathSeparator()))) {
            outerPath = outerPath + String.valueOf(this.config.getPathSeparator());
        }
        try {
            InputStream stream = this.getFile(outerPath + "info.json");
            if (stream != null) {
                info = (VersionInfo)Config.getObjectMapper().readValue(stream, VersionInfo.class);
            }
        }
        catch (StorageException e) {
            this.log.error((Object)("Cannot get VersionInfo from: " + outerPath), (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"Exception while reading VersionInfo!", (Throwable)e);
            throw new StorageException("Exception while reading VersionInfo", e);
        }
        return info;
    }

    private void writeVersionInfo(String outerPath, VersionInfo info) {
        if (outerPath == null || outerPath.isEmpty()) {
            throw new IllegalArgumentException("outerPath is not allowed to be empty");
        }
        if (info == null) {
            info = new VersionInfo();
        }
        if (!outerPath.endsWith(String.valueOf(this.config.getPathSeparator()))) {
            outerPath = outerPath + String.valueOf(this.config.getPathSeparator());
        }
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(Config.getObjectMapper().writeValueAsBytes((Object)info));
            this.storeFile(input, outerPath + "info.json", true);
            input.close();
        }
        catch (StorageException | IOException e) {
            this.log.error((Object)"Cannot write VersionInfo", (Throwable)e);
        }
    }

    public URL getHttpAccessPath() {
        return this.httpAccessPath;
    }

    public void setHttpAccessPath(URL httpAccessPath) {
        this.httpAccessPath = httpAccessPath;
    }

    protected static class VersionInfo {
        private String origin = null;
        private Map<String, FileVersionInfo> models = new HashMap<String, FileVersionInfo>();

        protected VersionInfo() {
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        public Map<String, FileVersionInfo> getModels() {
            return this.models;
        }

        public void setModels(Map<String, FileVersionInfo> models) {
            this.models = models;
        }

        @JsonIgnore
        public FileVersionInfo getSingleModel(String fileId) {
            return this.models.get(fileId);
        }

        public FileVersionInfo addModel(String fileId) {
            FileVersionInfo result = null;
            if (!this.models.containsKey(fileId)) {
                result = new FileVersionInfo();
                result.setFileId(fileId);
                this.models.put(fileId, result);
            } else {
                result = this.models.get(fileId);
            }
            return result;
        }

        protected static class FileVersionInfo {
            private String fileId = null;
            private Map<String, Date> versions = new HashMap<String, Date>();

            protected FileVersionInfo() {
            }

            public String getFileId() {
                return this.fileId;
            }

            public void setFileId(String fileId) {
                this.fileId = fileId;
            }

            public Map<String, Date> getVersions() {
                return this.versions;
            }

            public void addVersion(Date versionDate, String versionId) {
                this.versions.put(versionId, versionDate);
            }
        }
    }
}

