/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.unirostock.sems.ModelCrawler.Constants;
import de.unirostock.sems.ModelCrawler.databases.Interface.ModelDatabase;
import de.unirostock.sems.ModelCrawler.exceptions.ConfigurationException;
import de.unirostock.sems.ModelCrawler.storage.ModelStorage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config
implements Serializable {
    private static final long serialVersionUID = 3875736107816341962L;
    private static final Log log = LogFactory.getLog(Config.class);
    private static volatile Config instance = null;
    private static volatile ObjectMapper mapper = null;
    private static WorkingMode workingMode = WorkingMode.NORMAL;
    private File workingDir = null;
    private File tempDir = null;
    private String encoding = "UTF-8";
    private char pathSeparator = (char)47;
    private String[] extensionBlacklist = new String[]{"png", "bmp", "jpg", "jpeg", "html", "xhtml", "svg", "pdf", "json", "pl", "rdf", "rar", "msh", "zip"};
    private String tempDirPrefix = "ModelCrawler";
    private String workingDirConfig = "config.json";
    private String urnNamespace = "model";
    private String morreUrl = "http://localhost:7474/morre/";
    private List<ModelDatabase> databases = new ArrayList<ModelDatabase>();
    private ModelStorage storage = null;

    public static Config getConfig() {
        if (instance == null) {
            throw new IllegalStateException("Config not loaded");
        }
        return instance;
    }

    public static ObjectMapper getObjectMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.enable(SerializationFeature.WRITE_NULL_MAP_VALUES);
            mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        }
        return mapper;
    }

    public static synchronized Config load(File location) throws ConfigurationException {
        if (instance != null) {
            throw new IllegalStateException("Config already loaded");
        }
        try {
            instance = (Config)Config.getObjectMapper().readValue(location, Config.class);
        }
        catch (IOException e) {
            log.error((Object)("Error while reading config file " + location.getAbsolutePath()), (Throwable)e);
            throw new ConfigurationException("Error while reading config file " + location.getAbsolutePath(), e);
        }
        return instance;
    }

    public static synchronized Config defaultConfig() {
        if (instance != null) {
            throw new IllegalStateException("Config already loaded");
        }
        instance = new Config();
        return instance;
    }

    public static WorkingMode getWorkingMode() {
        return workingMode;
    }

    public static void setWorkingMode(WorkingMode workingMode) {
        Config.workingMode = workingMode;
    }

    private Config() {
    }

    public synchronized void save(File location) throws ConfigurationException {
        try {
            Config.getObjectMapper().writeValue(location, (Object)this);
        }
        catch (IOException e) {
            log.error((Object)("Error while writing config file " + location.getAbsolutePath()), (Throwable)e);
            throw new ConfigurationException("Error while writing config file " + location.getAbsolutePath(), e);
        }
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public File getTempDir() {
        if (this.tempDir == null) {
            try {
                log.warn((Object)"Creates default temp dir, because config parameter was not set");
                this.tempDir = Files.createTempDirectory("modelcrawler", Constants.TEMP_DIR_POSIX_ATTRIBUTES).toFile();
                log.info((Object)MessageFormat.format("temp directory was set to {0}", this.tempDir.getAbsolutePath()));
                this.tempDir.deleteOnExit();
            }
            catch (IOException e) {
                log.error((Object)"Not able to create default temp directory", (Throwable)e);
                return null;
            }
        }
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        if (tempDir == null) {
            return;
        }
        this.tempDir = tempDir;
        tempDir.mkdirs();
        tempDir.deleteOnExit();
        log.info((Object)MessageFormat.format("temp directory was set to {0}", tempDir.getAbsolutePath()));
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public char getPathSeparator() {
        return this.pathSeparator;
    }

    @JsonIgnore
    public String getPathSeparatorString() {
        return String.valueOf(this.pathSeparator);
    }

    public void setPathSeparator(char pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    public String[] getExtensionBlacklist() {
        return this.extensionBlacklist;
    }

    public void setExtensionBlacklist(String[] extensionBlacklist) {
        this.extensionBlacklist = extensionBlacklist;
    }

    public List<ModelDatabase> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<ModelDatabase> databases) {
        this.databases = databases;
    }

    public String getTempDirPrefix() {
        return this.tempDirPrefix;
    }

    public void setTempDirPrefix(String tempDirPrefix) {
        this.tempDirPrefix = tempDirPrefix;
    }

    public String getWorkingDirConfig() {
        return this.workingDirConfig;
    }

    public void setWorkingDirConfig(String workingDirConfig) {
        this.workingDirConfig = workingDirConfig;
    }

    public String getMorreUrl() {
        return this.morreUrl;
    }

    public void setMorreUrl(String morreUrl) {
        this.morreUrl = morreUrl;
    }

    public ModelStorage getStorage() {
        return this.storage;
    }

    public void setStorage(ModelStorage storage) {
        this.storage = storage;
    }

    public String getUrnNamespace() {
        return this.urnNamespace;
    }

    public void setUrnNamespace(String urnNamespace) {
        this.urnNamespace = urnNamespace;
    }

    public static enum WorkingMode {
        NORMAL,
        TEMPLATE_CONFIG,
        TEST,
        NO_MORRE;

    }
}

