/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.databases.Interface;

import de.unirostock.sems.ModelCrawler.Config;
import de.unirostock.sems.ModelCrawler.helper.CrawledModelRecord;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;

public abstract class Change
extends CrawledModelRecord
implements Comparable<Change> {
    private static final long serialVersionUID = 3880353134783045794L;
    private transient Date versionDate = null;
    private transient Date crawledDate = null;
    protected transient File xmlFile = null;
    protected transient URL repositoryUrl = null;
    protected transient String filePath = null;
    protected String fileName = null;
    protected String versionId = null;

    public Change(URL repositoryUrl, String filePath, String versionId, Date versionDate, Date crawledDate) throws URISyntaxException {
        super(Change.generateFileId(repositoryUrl, filePath), versionId, versionDate, crawledDate);
        this.repositoryUrl = repositoryUrl;
        this.filePath = filePath;
        this.fileName = new String(FilenameUtils.getBaseName((String)filePath) + "." + FilenameUtils.getExtension((String)filePath));
        this.versionId = versionId;
        this.versionDate = versionDate;
        this.crawledDate = crawledDate;
    }

    public static String generateFileId(URL repositoryUrl, String filePath) throws URISyntaxException {
        if (repositoryUrl == null) {
            throw new IllegalArgumentException("Repository URL not provided");
        }
        if (filePath == null || filePath.isEmpty()) {
            throw new IllegalArgumentException("File path not provided");
        }
        Config config = Config.getConfig();
        StringBuilder fileId = new StringBuilder("urn");
        fileId.append(":");
        fileId.append(config.getUrnNamespace());
        fileId.append(":");
        fileId.append(repositoryUrl.getHost());
        fileId.append(":");
        String[] repositoryPathParts = repositoryUrl.getPath().split("\\/");
        for (int index = 0; index < repositoryPathParts.length; ++index) {
            if (repositoryPathParts[index] == null || repositoryPathParts[index].isEmpty()) continue;
            if (repositoryPathParts[index].startsWith("!")) {
                repositoryPathParts[index] = repositoryPathParts[index].substring("!".length());
            }
            fileId.append(repositoryPathParts[index]);
            fileId.append(":");
        }
        fileId.append("!");
        fileId.append(":");
        String[] filePathParts = filePath.split("\\/");
        for (int index = 0; index < filePathParts.length; ++index) {
            if (filePathParts[index] == null || filePathParts[index].isEmpty()) continue;
            if (filePathParts[index].startsWith("!")) {
                filePathParts[index] = filePathParts[index].substring("!".length());
            }
            fileId.append(filePathParts[index]);
            if (filePathParts.length - index <= 1) continue;
            fileId.append(":");
        }
        return fileId.toString();
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    public boolean setXmlFile(File xmlFile) {
        return this.setXmlFile(xmlFile, false);
    }

    public boolean setXmlFile(File xmlFile, boolean override) {
        if (this.xmlFile == null || override) {
            this.xmlFile = xmlFile;
            return true;
        }
        return false;
    }

    @Override
    public void setVersionDate(Date versionDate) {
        super.setVersionDate(versionDate);
        this.versionDate = versionDate;
    }

    @Override
    public Date getVersionDate() {
        if (this.versionDate == null) {
            this.versionDate = super.getVersionDate();
        }
        return this.versionDate;
    }

    @Override
    public void setCrawledDate(Date crawledDate) {
        super.setCrawledDate(crawledDate);
        this.crawledDate = crawledDate;
    }

    @Override
    public Date getCrawledDate() {
        if (this.crawledDate == null) {
            this.crawledDate = super.getCrawledDate();
        }
        return this.crawledDate;
    }

    @Override
    public int compareTo(Change change) {
        return this.getVersionDate().compareTo(change.getVersionDate());
    }

    public String toString() {
        return "Chg:" + this.getFileId() + "@" + this.getVersionId();
    }

    public String getChangeRepositoryUrl(Change change) {
        return change.repositoryUrl.toString();
    }

    public String getChangeFilePath(Change change) {
        return change.filePath;
    }

    public String getChangeFileName(Change change) {
        return change.fileName;
    }

    public String getChangeVersionId(Change change) {
        return change.versionId;
    }

    public String getChangeVersionDate(Change change) {
        return change.versionDate.toString();
    }

    public String getChangeCrawledDate(Change change) {
        return change.crawledDate.toString();
    }
}

