/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.ModelCrawler.helper;

import de.unirostock.sems.morre.client.dataholder.CrawledModel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrawledModelRecord
extends CrawledModel {
    private static final long serialVersionUID = 6382870895044981027L;
    public static final String DATE_FORMAT = "dd.MM.yyyy-HH:mm:ss";

    public static CrawledModelRecord extendDataholder(CrawledModel model) {
        if (model != null) {
            return new CrawledModelRecord(model);
        }
        return null;
    }

    public CrawledModelRecord(CrawledModel model) {
        super(model.getFileId(), model.getVersionId(), model.getXmldoc(), model.getParentMap(), model.getMetaMap(), model.getModelType());
    }

    public CrawledModelRecord(String fileId, String versionId, String xmldoc, Map<String, List<String>> parentMap, Map<String, String> metaMap, String modelType) {
        super(fileId, versionId, xmldoc, parentMap, metaMap, modelType);
    }

    public CrawledModelRecord(String fileId, String versionId, String xmldoc, Map<String, List<String>> parentMap, Map<String, String> metaMap, String modelType, Date versionDate, Date crawledDate) {
        super(fileId, versionId, xmldoc, parentMap, metaMap, modelType);
        this.setVersionDate(versionDate);
        this.setCrawledDate(crawledDate);
    }

    public CrawledModelRecord(String fileId, String versionId, Date versionDate, Date crawledDate) {
        super(fileId, versionId, null, null, null, null);
        this.setVersionDate(versionDate);
        this.setCrawledDate(crawledDate);
    }

    public boolean isAvailable() {
        if (this.getFileId() == null || this.getFileId().isEmpty()) {
            return false;
        }
        if (this.getVersionId() == null || this.getVersionId().isEmpty()) {
            return false;
        }
        return this.getXmldoc() != null && !this.getXmldoc().isEmpty();
    }

    public String getMeta(String metaField) {
        Map metaMap = this.getMetaMap();
        if (metaMap == null) {
            return null;
        }
        return (String)metaMap.get(metaField);
    }

    public void setMeta(String metaField, String value) {
        HashMap<String, String> metaMap = this.getMetaMap();
        if (metaMap == null) {
            metaMap = new HashMap<String, String>();
            this.setMetaMap(metaMap);
        }
        metaMap.put(metaField, value);
    }

    public Date getVersionDate() {
        Date versionDate = null;
        String date = this.getMeta("versionDate");
        if (date == null) {
            return null;
        }
        try {
            versionDate = new SimpleDateFormat(DATE_FORMAT).parse(date);
        }
        catch (ParseException e) {
            return null;
        }
        return versionDate;
    }

    public void setVersionDate(Date versionDate) {
        this.setMeta("versionDate", new SimpleDateFormat(DATE_FORMAT).format(versionDate));
    }

    public Date getCrawledDate() {
        Date crawledDate = null;
        String date = this.getMeta("crawledDate");
        if (date == null) {
            return null;
        }
        try {
            crawledDate = new SimpleDateFormat(DATE_FORMAT).parse(date);
        }
        catch (ParseException e) {
            return null;
        }
        return crawledDate;
    }

    public void setCrawledDate(Date crawledDate) {
        this.setMeta("crawledDate", new SimpleDateFormat(DATE_FORMAT).format(crawledDate));
    }

    public void addParent(String parentFileId, String parentVersionId) {
        ArrayList<String> fileIdList;
        if (parentFileId == null || parentFileId.isEmpty() || parentVersionId == null || parentVersionId.isEmpty()) {
            throw new IllegalArgumentException("parentFileId and/or parentVersionId are not allowed to be null or empty!");
        }
        HashMap<String, ArrayList<String>> parentMap = null;
        if (this.getParentMap() == null) {
            parentMap = new HashMap<String, ArrayList<String>>();
            this.setParentMap(parentMap);
        }
        if ((fileIdList = (ArrayList<String>)parentMap.get(parentFileId)) == null) {
            fileIdList = new ArrayList<String>();
            parentMap.put(parentFileId, fileIdList);
        }
        fileIdList.add(parentVersionId);
    }

    public void addParent(String parentVersionId) {
        this.addParent(this.getFileId(), parentVersionId);
    }
}

