/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.XmlFileServerClient.impl;

import de.unirostock.sems.XmlFileServerClient.XmlFileServer;
import de.unirostock.sems.XmlFileServerClient.exceptions.ModelAlreadyExistsException;
import de.unirostock.sems.XmlFileServerClient.exceptions.ModelNotFoundException;
import de.unirostock.sems.XmlFileServerClient.exceptions.UnsupportedUriException;
import de.unirostock.sems.XmlFileServerClient.exceptions.XmlFileServerBadRequestException;
import de.unirostock.sems.XmlFileServerClient.exceptions.XmlFileServerProtocollException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpXmlFileServerClient
implements XmlFileServer {
    private final Log log = LogFactory.getLog(HttpXmlFileServerClient.class);
    public static final int STATUS_NOT_FOUND = 404;
    public static final int STATUS_MODEL_ALREADY_EXISTS = 403;
    public static final int STATUS_BAD_REQUEST = 400;
    public static final int STATUS_SERVER_ERROR = 500;
    public static final int STATUS_MODEL_WRITTEN = 201;
    public static final int STATUS_MODEL_DELIVERED = 200;
    private static final String PARAMETER_MODEL_ID = "modelId";
    private static final String PARAMETER_VERSION_ID = "versionId";
    private static final String PARAMETER_REPO_URL = "repositoryUrl";
    private static final String PARAMETER_FILE_PATH = "filePath";
    private static final String PARAMETER_MODEL_STREAM = "file";
    private static final String MODEL_MIMETYPE = "application/xml";
    private static final String HEADER_LOCATION = "location";
    private URI xmlFileServer;
    private String prefixPath;
    private HttpClient client;

    public HttpXmlFileServerClient(URI xmlFileServer) {
        this.xmlFileServer = xmlFileServer;
        this.prefixPath = xmlFileServer.getPath();
        this.client = new DefaultHttpClient();
    }

    private URI generateRequestUri(URI model) throws UnsupportedUriException {
        String requestPath;
        URI requestUri = null;
        if (this.prefixPath.isEmpty() || this.prefixPath.equals("/")) {
            requestPath = model.getPath();
        } else {
            requestPath = model.getPath();
            if (!requestPath.toLowerCase().startsWith(this.prefixPath.toLowerCase())) {
                if (!this.prefixPath.endsWith("/") && !requestPath.startsWith("/")) {
                    requestPath = this.prefixPath + "/" + requestPath;
                } else if (this.prefixPath.endsWith("/") && requestPath.startsWith("/")) {
                    requestPath = this.prefixPath.substring(1) + requestPath;
                }
            }
        }
        try {
            requestUri = new URI(this.xmlFileServer.getScheme(), null, this.xmlFileServer.getHost(), this.xmlFileServer.getPort(), requestPath, null, null);
        }
        catch (URISyntaxException e) {
            String message = MessageFormat.format("UriSyntax error while generating the requestUri for {0}", model);
            this.log.error((Object)message, (Throwable)e);
            throw new UnsupportedUriException(message, e);
        }
        return requestUri;
    }

    private String generateDebugModelIdentifier(String modelId, String filePath, String repositoryUrl, String versionId) {
        StringBuilder result = new StringBuilder();
        if (modelId != null && !modelId.isEmpty()) {
            result.append(modelId);
        } else {
            result.append(repositoryUrl);
            result.append(':');
            result.append(filePath);
        }
        result.append(':');
        result.append(versionId);
        return result.toString();
    }

    @Override
    public InputStream resolveModelUri(URI model) throws ModelNotFoundException, UnsupportedUriException, XmlFileServerProtocollException, IOException {
        HttpResponse response = null;
        URI requestUri = this.generateRequestUri(model);
        HttpGet request = new HttpGet(requestUri);
        try {
            response = this.client.execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e) {
            String message = MessageFormat.format("Http Client Protocoll Exception while resolving model {0}", model);
            this.log.error((Object)message, (Throwable)e);
            throw new XmlFileServerProtocollException(message, e);
        }
        catch (IOException e) {
            String message = MessageFormat.format("IOException while resolving model {0}", model);
            this.log.error((Object)message, (Throwable)e);
            throw new IOException(message, e);
        }
        if (response == null) {
            String message = MessageFormat.format("No response. {0}", model);
            this.log.error((Object)message);
            return null;
        }
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                return response.getEntity().getContent();
            }
            catch (IllegalStateException e) {
                String message = MessageFormat.format("IllegalState while returning the resolved data of model {0}", model);
                this.log.error((Object)message, (Throwable)e);
                throw new IllegalStateException(message, e);
            }
            catch (IOException e) {
                String message = MessageFormat.format("IOException while returning the resolved data of model {0}", model);
                this.log.error((Object)message, (Throwable)e);
                throw new IOException(message, e);
            }
        }
        throw new ModelNotFoundException(response.getStatusLine().getReasonPhrase());
    }

    @Override
    public boolean exist(URI model) throws UnsupportedUriException, IOException, XmlFileServerProtocollException {
        HttpResponse response = null;
        URI requestUri = this.generateRequestUri(model);
        HttpHead request = new HttpHead(requestUri);
        try {
            response = this.client.execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e) {
            String message = MessageFormat.format("Http Client Protocoll Exception while resolving model {0}", model);
            this.log.error((Object)message, (Throwable)e);
            throw new XmlFileServerProtocollException(message, e);
        }
        catch (IOException e) {
            String message = MessageFormat.format("IOException while resolving model {0}", model);
            this.log.error((Object)message, (Throwable)e);
            throw new IOException(message, e);
        }
        if (response == null) {
            String message = MessageFormat.format("No response. {0}", model);
            this.log.error((Object)message);
            return false;
        }
        return response.getStatusLine().getStatusCode() == 200;
    }

    @Override
    public boolean isResolvableUri(URI model) {
        if (!model.getScheme().equals(this.xmlFileServer.getScheme())) {
            return false;
        }
        return model.getHost().equals(this.xmlFileServer.getHost());
    }

    @Override
    public URI pushModel(String modelId, String versionId, InputStream modelSource) throws IOException, UnsupportedUriException, XmlFileServerProtocollException, ModelAlreadyExistsException, XmlFileServerBadRequestException {
        return this.pushModel(modelId, versionId, null, null, modelSource);
    }

    @Override
    public URI pushModel(String repositoryUrl, String filePath, String versionId, InputStream modelSource) throws IOException, UnsupportedUriException, XmlFileServerProtocollException, ModelAlreadyExistsException, XmlFileServerBadRequestException {
        return this.pushModel(null, versionId, repositoryUrl, filePath, modelSource);
    }

    @Override
    public URI pushModel(String modelId, String versionId, String repositoryUrl, String filePath, InputStream modelSource) throws UnsupportedUriException, XmlFileServerProtocollException, IOException, ModelAlreadyExistsException, XmlFileServerBadRequestException {
        HttpPost request;
        String message;
        if (versionId == null || versionId.isEmpty()) {
            throw new IllegalArgumentException("The versionId is not set!");
        }
        if (modelSource == null) {
            throw new IllegalArgumentException("The modelStream is null! So why did you call this method?");
        }
        HttpResponse response = null;
        Charset charset = Charset.forName("UTF-8");
        MultipartEntity entity = new MultipartEntity(null, null, charset);
        try {
            entity.addPart(PARAMETER_VERSION_ID, (ContentBody)new StringBody(versionId, charset));
            if (repositoryUrl != null && filePath != null && !repositoryUrl.isEmpty() && !filePath.isEmpty()) {
                entity.addPart(PARAMETER_REPO_URL, (ContentBody)new StringBody(repositoryUrl, charset));
                entity.addPart(PARAMETER_FILE_PATH, (ContentBody)new StringBody(filePath, charset));
            } else if (modelId != null && !modelId.isEmpty()) {
                entity.addPart(PARAMETER_MODEL_ID, (ContentBody)new StringBody(modelId, charset));
            } else {
                throw new IllegalArgumentException("Insufficient amount of parameter. You are supposed to either set modelId or repositoryUrl and filePath!");
            }
            entity.addPart(PARAMETER_MODEL_STREAM, (ContentBody)new InputStreamBody(modelSource, MODEL_MIMETYPE, versionId));
        }
        catch (UnsupportedEncodingException e) {
            message = MessageFormat.format("Charset {0} is not supported!", "UTF-8");
            this.log.fatal((Object)message, (Throwable)e);
        }
        try {
            request = new HttpPost(this.xmlFileServer);
            request.setEntity((HttpEntity)entity);
            response = this.client.execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e) {
            message = MessageFormat.format("Http Client Protocoll Exception while pushing model {0} to server", this.generateDebugModelIdentifier(modelId, filePath, repositoryUrl, versionId));
            this.log.error((Object)message, (Throwable)e);
            throw new XmlFileServerProtocollException(message, e);
        }
        catch (IOException e) {
            message = MessageFormat.format("IOException while pushing model {0} to server", this.generateDebugModelIdentifier(modelId, filePath, repositoryUrl, versionId));
            this.log.error((Object)message, (Throwable)e);
            throw new IOException(message, e);
        }
        request.releaseConnection();
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 201) {
            String status = response.getStatusLine().getReasonPhrase();
            if (status.endsWith("MODEXS")) {
                String message2 = MessageFormat.format("Model {1} already exist: \"{0}\"", status, this.generateDebugModelIdentifier(modelId, filePath, repositoryUrl, versionId));
                this.log.error((Object)message2);
                throw new ModelAlreadyExistsException(message2);
            }
            if (status.endsWith("INVURI")) {
                String message3 = MessageFormat.format("Unsupported URI while pushing model {1} : \"{0}\"", status, this.generateDebugModelIdentifier(modelId, filePath, repositoryUrl, versionId));
                this.log.error((Object)message3);
                throw new UnsupportedUriException(message3);
            }
            String message4 = MessageFormat.format("BadRequest while pushing model {1} : \"{0}\"", status, this.generateDebugModelIdentifier(modelId, filePath, repositoryUrl, versionId));
            this.log.error((Object)message4);
            throw new XmlFileServerBadRequestException(message4);
        }
        Header location = response.getLastHeader(HEADER_LOCATION);
        if (location == null) {
            this.log.error((Object)MessageFormat.format("Location field is null after pushing model {0}", this.generateDebugModelIdentifier(modelId, filePath, repositoryUrl, versionId)));
            return null;
        }
        try {
            return new URI(location.getValue());
        }
        catch (URISyntaxException e) {
            String message5 = MessageFormat.format("Can not parse the location field after pushed model {0} to server", this.generateDebugModelIdentifier(modelId, filePath, repositoryUrl, versionId));
            this.log.error((Object)message5);
            throw new UnsupportedUriException(message5, e);
        }
    }
}

