/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.comodi;

import de.unirostock.sems.comodi.Change;
import de.unirostock.sems.xmlutils.ds.DocumentNode;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.jdom2.Element;

public class ChangeFactory {
    private Model model;
    public static final String RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDFS_NS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String COMODI_NS = "http://purl.uni-rostock.de/comodi/comodi#";
    public static final String PROV_NS = "http://www.w3.org/ns/prov#";
    public static final String PAV_NS = "http://purl.org/pav/";
    public static final String FOAF_NS = "http://xmlns.com/foaf/0.1/";
    public static final String ORE_NS = "http://www.openarchives.org/ore/terms/";
    private URI baseUri;
    private List<Change> changes;

    public ChangeFactory(URI baseUri) {
        this.baseUri = baseUri;
        this.model = ModelFactory.createDefaultModel();
        this.model.setNsPrefix("comodi", COMODI_NS);
        this.model.setNsPrefix("rdf", RDF_NS);
        this.model.setNsPrefix("rdfs", RDFS_NS);
        this.model.setNsPrefix("foaf", FOAF_NS);
        this.model.setNsPrefix("prov", PROV_NS);
        this.model.setNsPrefix("pav", PAV_NS);
        this.model.setNsPrefix("ore", ORE_NS);
        this.changes = new ArrayList<Change>();
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public List<Change> getChanges() {
        return this.changes;
    }

    public int getNumStatements() {
        int i = 0;
        for (Change change : this.changes) {
            i += change.getStatements().size();
        }
        return i;
    }

    public int getNumChanges() {
        return this.changes.size();
    }

    public Change createChange(String subjectId) {
        return this.createChange(subjectId, "Change");
    }

    public static String getSubjectId(Element node) {
        return node.getAttributeValue("id");
    }

    public static String getSubjectId(DocumentNode node) {
        return node.getId();
    }

    protected Change createChange(String subjectId, String type) {
        Change change = new Change(subjectId, this.model, this.baseUri, type);
        this.changes.add(change);
        return change;
    }

    public Change createInsertion(String subjectId) {
        return this.createChange(subjectId, "Insertion");
    }

    public Change createDeletion(String subjectId) {
        return this.createChange(subjectId, "Deletion");
    }

    public Change createUpdate(String subjectId) {
        return this.createChange(subjectId, "Update");
    }

    public Change createMove(String subjectId) {
        return this.createChange(subjectId, "Move");
    }

    public Change createPermutationOfEntities(String subjectId) {
        return this.createChange(subjectId, "PermutationOfEntities");
    }

    public String getRdfXml() {
        for (Change change : this.changes) {
            this.model.add(change.getStatements());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.model.write((OutputStream)out, "RDF/XML-ABBREV");
        return out.toString();
    }

    public Model getAnnotaions() {
        for (Change change : this.changes) {
            this.model.add(change.getStatements());
        }
        return this.model;
    }

    public void printTtl() {
        for (Change change : this.changes) {
            this.model.add(change.getStatements());
        }
        this.model.write((OutputStream)System.out, "TURTLE");
    }

    public void printXml() {
        for (Change change : this.changes) {
            this.model.add(change.getStatements());
        }
        this.model.write((OutputStream)System.out, "RDF/XML-ABBREV");
    }
}

