/*
 * Decompiled with CFR 0.152.
 */
package de.unirostock.sems.comodi;

import de.unirostock.sems.comodi.branches.ComodiIntention;
import de.unirostock.sems.comodi.branches.ComodiReason;
import de.unirostock.sems.comodi.branches.ComodiTarget;
import de.unirostock.sems.comodi.branches.ComodiXmlEntity;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;

public class Change {
    private Resource subject;
    private Model model;
    private List<Statement> statements;
    private URI baseUri;

    public Change(String subjectId, Model model, URI baseUri, String type) {
        this.init(subjectId, model, baseUri, type);
    }

    private void init(String nodeId, Model model, URI baseUri, String type) {
        this.baseUri = baseUri;
        this.model = model;
        this.subject = model.createResource(baseUri.toString() + "#" + nodeId);
        this.statements = new ArrayList<Statement>();
        this.statements.add(model.createStatement(this.subject, model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type"), (RDFNode)model.createResource("http://purl.uni-rostock.de/comodi/comodi#" + type)));
    }

    public Resource getChangeAsResource() {
        return this.subject;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public Change appliesTo(ComodiXmlEntity entity) {
        this.statements.add(this.model.createStatement(this.subject, this.model.createProperty("http://purl.uni-rostock.de/comodi/comodi#", "appliesTo"), (RDFNode)this.model.createResource("http://purl.uni-rostock.de/comodi/comodi#" + entity.getTerm())));
        return this;
    }

    public Change hasIntention(ComodiIntention intention) {
        this.statements.add(this.model.createStatement(this.subject, this.model.createProperty("http://purl.uni-rostock.de/comodi/comodi#", "hasIntention"), (RDFNode)this.model.createResource("http://purl.uni-rostock.de/comodi/comodi#" + intention.getTerm())));
        return this;
    }

    public Change hasReason(ComodiReason reason) {
        this.statements.add(this.model.createStatement(this.subject, this.model.createProperty("http://purl.uni-rostock.de/comodi/comodi#", "hasReason"), (RDFNode)this.model.createResource("http://purl.uni-rostock.de/comodi/comodi#" + reason.getTerm())));
        return this;
    }

    public Change affects(ComodiTarget target) {
        this.statements.add(this.model.createStatement(this.subject, this.model.createProperty("http://purl.uni-rostock.de/comodi/comodi#", "affects"), (RDFNode)this.model.createResource("http://purl.uni-rostock.de/comodi/comodi#" + target.getTerm())));
        return this;
    }

    public Change wasTriggeredBy(String nodeId) {
        this.statements.add(this.model.createStatement(this.subject, this.model.createProperty("http://purl.uni-rostock.de/comodi/comodi#", "wasTriggeredBy"), (RDFNode)this.model.createResource(this.baseUri.toString() + "#" + nodeId)));
        return this;
    }

    public Change addAnnotation(Property predicate, RDFNode object) {
        this.statements.add(this.model.createStatement(this.subject, predicate, object));
        return this;
    }
}

