/*
 * Decompiled with CFR 0.152.
 */
package de.binfalse.jatter;

import de.binfalse.bflog.LOGGER;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Config {
    private Properties prop = new Properties();
    private static String JABBER_SERVER = "jabber.server";
    private static String JABBER_PORT = "jabber.port";
    private static String JABBER_USER = "jabber.user";
    private static String JABBER_PASSWORD = "jabber.password";
    private static String JABBER_CONTACT = "jabber.contact";
    private static String TWITTER_POLLINGINTERVALL = "twitter.pollingintervall";
    private static String TWITTER_CONSUMER_KEY = "twitter.consumer.key";
    private static String TWITTER_CONSUMER_SECRET = "twitter.consumer.secret";
    private static String TWITTER_ACCESSTOKEN = "twitter.accesstoken";
    private static String TWITTER_ACCESSTOKEN_SECRET = "twitter.accesstoken.secret";
    private static String TWITTER_LOCATION_LATITUDE = "twitter.location.latitude";
    private static String TWITTER_LOCATION_LONGITUDE = "twitter.location.longitude";

    public void readConfig(String file) throws IOException {
        LOGGER.info((Object[])new Object[]{"reading configuration at ", file});
        try (FileInputStream in = new FileInputStream(file);){
            this.prop.clear();
            this.prop.load(in);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object[])new Object[]{"found ", this.prop.size(), " configuration options:"});
            for (Object s : this.prop.keySet()) {
                LOGGER.debug((Object[])new Object[]{" > ", s, " -> ", this.prop.get(s).toString().length(), " chars"});
            }
        }
    }

    public void writeConfig(String file) throws IOException {
        LOGGER.info((Object[])new Object[]{"writing configuration to ", file});
        try (FileOutputStream out = new FileOutputStream(file);){
            this.prop.store(out, null);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object[])new Object[]{"wrote ", this.prop.size(), " configuration options:"});
            for (Object s : this.prop.keySet()) {
                LOGGER.debug((Object[])new Object[]{" > ", s, " -> ", this.prop.get(s).toString().length(), " chars"});
            }
        }
    }

    public void setJabberServer(String server) {
        this.prop.setProperty(JABBER_SERVER, server);
    }

    public void setJabberUser(String value) {
        this.prop.setProperty(JABBER_USER, value);
    }

    public void setJabberPassword(String value) {
        this.prop.setProperty(JABBER_PASSWORD, value);
    }

    public void setJabberContact(String value) {
        this.prop.setProperty(JABBER_CONTACT, value);
    }

    public void setJabberPort(String value) {
        this.prop.setProperty(JABBER_PORT, value);
    }

    public void setTwitterPollingintervall(String value) {
        this.prop.setProperty(TWITTER_POLLINGINTERVALL, value);
    }

    public void setTwitterConsumerKey(String value) {
        this.prop.setProperty(TWITTER_CONSUMER_KEY, value);
    }

    public void setTwitterConsumerSecret(String value) {
        this.prop.setProperty(TWITTER_CONSUMER_SECRET, value);
    }

    public void setTwitterAccesstoken(String value) {
        this.prop.setProperty(TWITTER_ACCESSTOKEN, value);
    }

    public void setTwitterAccesstokenSecret(String value) {
        this.prop.setProperty(TWITTER_ACCESSTOKEN_SECRET, value);
    }

    public void setTwitterLocationLatitude(String value) {
        this.prop.setProperty(TWITTER_LOCATION_LATITUDE, value);
    }

    public void setTwitterLocationLongitude(String value) {
        this.prop.setProperty(TWITTER_LOCATION_LONGITUDE, value);
    }

    public String getJabberServer() {
        return this.prop.getProperty(JABBER_SERVER);
    }

    public String getJabberUser() {
        return this.prop.getProperty(JABBER_USER);
    }

    public String getJabberPassword() {
        return this.prop.getProperty(JABBER_PASSWORD);
    }

    public String getJabberContact() {
        return this.prop.getProperty(JABBER_CONTACT);
    }

    public String getJabberPort() {
        return this.prop.getProperty(JABBER_PORT);
    }

    public String getTwitterPollingintervall() {
        return this.prop.getProperty(TWITTER_POLLINGINTERVALL);
    }

    public String getTwitterConsumerKey() {
        return this.prop.getProperty(TWITTER_CONSUMER_KEY);
    }

    public String getTwitterConsumerSecret() {
        return this.prop.getProperty(TWITTER_CONSUMER_SECRET);
    }

    public String getTwitterAccesstoken() {
        return this.prop.getProperty(TWITTER_ACCESSTOKEN);
    }

    public String getTwitterAccesstokenSecret() {
        return this.prop.getProperty(TWITTER_ACCESSTOKEN_SECRET);
    }

    public String getTwitterLocationLatitude() {
        return this.prop.getProperty(TWITTER_LOCATION_LATITUDE);
    }

    public String getTwitterLocationLongitude() {
        return this.prop.getProperty(TWITTER_LOCATION_LONGITUDE);
    }
}

