/*
 * Decompiled with CFR 0.152.
 */
package de.binfalse.jatter.processors;

import de.binfalse.bflog.LOGGER;
import de.binfalse.jatter.Config;
import de.binfalse.jatter.JatterTools;
import de.binfalse.jatter.processors.TwitterStatusProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.xmpp.XmppMessage;
import org.jivesoftware.smack.packet.Message;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.User;

public class JabberMessageProcessor
implements Processor {
    private Config config;

    public JabberMessageProcessor(Config config) {
        this.config = config;
    }

    public static boolean isBotCommand(Exchange exchange) {
        String s = JabberMessageProcessor.getSmackMessage(exchange).getBody();
        boolean botCmd = s.startsWith("!");
        if (botCmd) {
            LOGGER.debug((Object[])new Object[]{"found bot command: ", s});
        }
        return botCmd;
    }

    public static Message getSmackMessage(Exchange exchange) {
        XmppMessage xmppMessage = (XmppMessage)exchange.getIn();
        Message smackMessage = xmppMessage.getXmppMessage();
        return smackMessage;
    }

    public void process(Exchange exchange) throws Exception {
        Message message = JabberMessageProcessor.getSmackMessage(exchange);
        String[] msg = message.getBody().substring(1).split("\\s+");
        boolean help = false;
        if (msg.length < 1 || msg[0].length() < 1) {
            exchange.getOut().setBody((Object)"there was no command... try !help");
            help = true;
        }
        String result = "";
        try {
            switch (msg[0]) {
                case "retweet": 
                case "rt": {
                    result = result + this.retweet(msg);
                    break;
                }
                case "favorite": 
                case "favourite": 
                case "fav": {
                    result = result + this.favorite(msg);
                    break;
                }
                case "delete": 
                case "del": {
                    result = result + this.delete(msg);
                    break;
                }
                case "location": {
                    result = result + "location";
                    break;
                }
                case "follow": {
                    result = result + this.follow(msg);
                    break;
                }
                case "unfollow": {
                    result = result + this.unfollow(msg);
                    break;
                }
                case "profile": {
                    result = result + this.getProfile(msg);
                    break;
                }
                default: {
                    help = true;
                    break;
                }
            }
        }
        catch (TwitterException e) {
            result = result + "received an *error from twitter*: " + e.getMessage();
        }
        if (help) {
            result = result + this.usage();
        }
        exchange.getOut().setBody((Object)result);
    }

    private String favorite(String[] commandLine) throws TwitterException {
        if (commandLine.length == 2) {
            long id = 0L;
            try {
                id = Long.parseLong(commandLine[1]);
            }
            catch (NumberFormatException e) {
                return "*" + id + "* is not a number";
            }
            Status status = JatterTools.getTwitterInstance(this.config).createFavorite(id);
            if (status != null) {
                return "fav'ed *" + id + "*\n" + TwitterStatusProcessor.translateTwitterStatus(status);
            }
            return "cannot find status *" + id + "*";
        }
        return "do not understand '" + String.join((CharSequence)" ", commandLine) + "'.. try !help";
    }

    private String delete(String[] commandLine) throws TwitterException {
        if (commandLine.length == 2) {
            long id = 0L;
            try {
                id = Long.parseLong(commandLine[1]);
            }
            catch (NumberFormatException e) {
                return "*" + id + "* is not a number";
            }
            Status status = JatterTools.getTwitterInstance(this.config).destroyStatus(id);
            if (status != null) {
                return "deleted *" + id + "*\n" + TwitterStatusProcessor.translateTwitterStatus(status);
            }
            return "cannot find status *" + id + "*";
        }
        return "do not understand '" + String.join((CharSequence)" ", commandLine) + "'.. try !help";
    }

    private String retweet(String[] commandLine) throws TwitterException {
        if (commandLine.length == 2) {
            long id = 0L;
            try {
                id = Long.parseLong(commandLine[1]);
            }
            catch (NumberFormatException e) {
                return "*" + id + "* is not a number";
            }
            Status status = JatterTools.getTwitterInstance(this.config).retweetStatus(id);
            if (status != null) {
                return "retweeted *" + id + "*\n" + TwitterStatusProcessor.translateTwitterStatus(status);
            }
            return "cannot find status *" + id + "*";
        }
        return "do not understand '" + String.join((CharSequence)" ", commandLine) + "'.. try !help";
    }

    private String unfollow(String[] commandLine) throws TwitterException {
        if (commandLine.length == 2) {
            String profile = commandLine[1];
            User user = JatterTools.getTwitterInstance(this.config).destroyFriendship(profile);
            if (user != null) {
                return "unfollowed *" + profile + "*\n" + JabberMessageProcessor.translateUser(user, profile);
            }
            return "cannot find *" + profile + "*";
        }
        return "do not understand '" + String.join((CharSequence)" ", commandLine) + "'.. try !help";
    }

    private String follow(String[] commandLine) throws TwitterException {
        if (commandLine.length == 2) {
            String profile = commandLine[1];
            User user = JatterTools.getTwitterInstance(this.config).createFriendship(profile);
            if (user != null) {
                return "following *" + profile + "*\n" + JabberMessageProcessor.translateUser(user, profile);
            }
            return "cannot find *" + profile + "*";
        }
        return "do not understand '" + String.join((CharSequence)" ", commandLine) + "'.. try !help";
    }

    public static String translateUser(User user, String profile) {
        String ret = "profile of *" + profile + "*\n" + "name: " + user.getName() + "\n" + "screen name: " + user.getScreenName() + "\n" + "id: " + user.getId() + "\n";
        if (user.getDescription() != null) {
            ret = ret + "description: " + user.getDescription() + "\n";
        }
        if (user.getURL() != null) {
            ret = ret + "url: " + JatterTools.expandUrl(user.getURL()) + "\n";
        }
        if (user.getLang() != null) {
            ret = ret + "language: " + user.getLang() + "\n";
        }
        if (user.getLocation() != null) {
            ret = ret + "location: " + user.getLocation() + "\n";
        }
        if (user.getTimeZone() != null) {
            ret = ret + "time zone: " + user.getTimeZone() + "\n";
        }
        ret = ret + "tweets: " + user.getStatusesCount() + "\n";
        ret = ret + "favourites: " + user.getFavouritesCount() + "\n";
        ret = ret + "followers: " + user.getFollowersCount() + "\n";
        ret = ret + "friends: " + user.getFriendsCount() + "\n";
        if (user.getStatus() != null) {
            ret = ret + "last status: " + TwitterStatusProcessor.translateTwitterStatus(user.getStatus());
        }
        return ret;
    }

    private String getProfile(String[] commandLine) throws TwitterException {
        if (commandLine.length == 2) {
            String profile = commandLine[1];
            User user = JatterTools.getTwitterInstance(this.config).users().showUser(profile);
            if (user != null) {
                return JabberMessageProcessor.translateUser(user, profile);
            }
            return "cannot find *" + profile + "*";
        }
        return "do not understand '" + String.join((CharSequence)" ", commandLine) + "'.. try !help";
    }

    public String usage() {
        return "\n*avaiable commands* (commands always start with !)\n*retweet|rt [ID]* retweet message\n*favourite|favorite|fav [ID]* fav message\n*delete|del [ID]* delete message\n*follow [USER]* start following a user\n*unfollow [USER]* stop following a user\n*profile [USER]* show the profile of a user - shows your profile if no USER is supplied\n*location [LATITUDE,LONGITUDE]* set the location of your status updates - to unset location leave argiments empty\n - [ID] is the last number in a Twitter status\n - [USER] is the username of a profile";
    }
}

