/*
 * Decompiled with CFR 0.152.
 */
package de.binfalse.jatter;

import de.binfalse.bflog.LOGGER;
import de.binfalse.jatter.Config;
import de.binfalse.jatter.processors.JabberMessageProcessor;
import de.binfalse.jatter.processors.TwitterStatusProcessor;
import de.binfalse.jatter.processors.TwitterUpdatePreprocessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.Main;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import twitter4j.TwitterException;

public class App {
    public static final SimpleDateFormat printDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void help(Options options, String msg) {
        System.out.println(msg);
        System.out.println();
        new HelpFormatter().printHelp("java -jar jatter.jar -c CONFIG", options);
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        CommandLine cmd;
        Options options = new Options();
        Option conf = new Option("c", "config", true, "config file path");
        conf.setRequired(false);
        options.addOption(conf);
        Option t = new Option("t", "template", false, "show a config template");
        t.setRequired(false);
        options.addOption(t);
        Option v = new Option("v", "verbose", false, "print information messages");
        v.setRequired(false);
        options.addOption(v);
        Option d = new Option("d", "debug", false, "print debugging messages incl stack traces");
        d.setRequired(false);
        options.addOption(d);
        Option h = new Option("h", "help", false, "show help");
        h.setRequired(false);
        options.addOption(h);
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
            if (cmd.hasOption("h")) {
                throw new RuntimeException("showing the help page");
            }
        }
        catch (Exception e) {
            App.help(options, e.getMessage());
            return;
        }
        if (cmd.hasOption("t")) {
            System.out.println();
            BufferedReader br = new BufferedReader(new InputStreamReader(App.class.getClassLoader().getResourceAsStream("config.properties.template")));
            while (br.ready()) {
                System.out.println(br.readLine());
            }
            br.close();
            System.exit(0);
        }
        if (cmd.hasOption("v")) {
            LOGGER.setMinLevel((int)2);
        }
        if (cmd.hasOption("d")) {
            LOGGER.setMinLevel((int)1);
            LOGGER.setLogStackTrace((boolean)true);
        }
        if (!cmd.hasOption("c")) {
            App.help(options, "a config file is required for running jatter");
        }
        App.startJatter(cmd.getOptionValue("c"));
    }

    public static void startJatter(String configFile) throws Exception {
        LOGGER.info((Object[])new Object[]{"starting jatter"});
        Config config = new Config();
        config.readConfig(configFile);
        LOGGER.debug((Object[])new Object[]{"creating a chat endpoint at"});
        final String chatEndpoint = String.format("xmpp://%s@%s:5222/%s?password=%s", config.getJabberUser(), config.getJabberServer(), config.getJabberContact(), config.getJabberPassword());
        LOGGER.debug((Object[])new Object[]{chatEndpoint.replaceAll("password=.*$", "password=XXX")});
        LOGGER.debug((Object[])new Object[]{"creating a twitter-home endpoint"});
        final String twitterHomeEndpoint = String.format("twitter://timeline/home?type=polling&delay=%s&consumerKey=%s&consumerSecret=%s&accessToken=%s&accessTokenSecret=%s", config.getTwitterPollingintervall(), config.getTwitterConsumerKey(), config.getTwitterConsumerSecret(), config.getTwitterAccesstoken(), config.getTwitterAccesstokenSecret());
        LOGGER.debug((Object[])new Object[]{"creating a twitter-mentions endpoint"});
        final String twitterMentionsEndpoint = String.format("twitter://timeline/mentions?type=polling&delay=%s&consumerKey=%s&consumerSecret=%s&accessToken=%s&accessTokenSecret=%s", config.getTwitterPollingintervall(), config.getTwitterConsumerKey(), config.getTwitterConsumerSecret(), config.getTwitterAccesstoken(), config.getTwitterAccesstokenSecret());
        LOGGER.debug((Object[])new Object[]{"creating a twitter-updater endpoint"});
        final String twitterUpdater = String.format("twitter://timeline/user?consumerKey=%s&consumerSecret=%s&accessToken=%s&accessTokenSecret=%s", config.getTwitterConsumerKey(), config.getTwitterConsumerSecret(), config.getTwitterAccesstoken(), config.getTwitterAccesstokenSecret());
        JivePropertiesManager.setJavaObjectEnabled((boolean)true);
        final TwitterStatusProcessor twitterStatusProc = new TwitterStatusProcessor(config);
        final JabberMessageProcessor jabberMessageProc = new JabberMessageProcessor(config);
        final TwitterUpdatePreprocessor tupre = new TwitterUpdatePreprocessor();
        Main main = new Main();
        LOGGER.info((Object[])new Object[]{"creating routes"});
        main.addRouteBuilder(new RouteBuilder(){

            public void configure() throws IOException {
                LOGGER.debug((Object[])new Object[]{"twitter-home -> status processor -> chat"});
                ((RouteDefinition)this.from(twitterHomeEndpoint).process((Processor)twitterStatusProc)).to(chatEndpoint);
                LOGGER.debug((Object[])new Object[]{"twitter-mentions -> status processor -> chat"});
                ((RouteDefinition)((RouteDefinition)this.from(twitterMentionsEndpoint).process((Processor)twitterStatusProc)).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String payload = (String)exchange.getIn().getBody(String.class);
                        exchange.getIn().setBody((Object)("*MENTIONED*: " + payload));
                    }
                })).to(chatEndpoint);
                LOGGER.debug((Object[])new Object[]{"chat -> decider -> twitter|bot"});
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from(chatEndpoint).choice().when(exchange -> JabberMessageProcessor.isBotCommand(exchange)).process((Processor)jabberMessageProc)).to(chatEndpoint)).otherwise().process((Processor)tupre)).doTry().to(twitterUpdater)).setBody((Expression)this.constant("timeline updated"))).to(chatEndpoint)).doCatch(TwitterException.class).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        LOGGER.debug((Object[])new Object[]{"chat message failed to send to twitter"});
                        String payload = (String)exchange.getIn().getBody(String.class);
                        exchange.getIn().setBody((Object)("*failed*: " + payload + " (length: " + payload.length() + ")"));
                    }
                })).to(chatEndpoint)).end().endChoice();
            }
        });
        main.run();
    }
}

